/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.recovery.partitions.states;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.recovery.states.PartitionStatesCall;
import org.apache.ignite3.internal.cli.call.recovery.states.PartitionStatesCallInput;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.commands.recovery.partitions.states.PartitionStatesMixin;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.TableDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="states", description={"Returns partition states."})
public class PartitionStatesReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private PartitionStatesMixin options;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private PartitionStatesCall call;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(url -> PartitionStatesCallInput.of(this.options, url)).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list partition states")).print(new TableDecorator(this.options.plain())));
    }
}

