/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore.status;

import java.util.UUID;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.DeploymentStatus;
import org.apache.ignite3.internal.deployunit.UnitStatus;
import org.apache.ignite3.internal.deployunit.metastore.status.SerializeUtils;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class UnitNodeStatus
extends UnitStatus {
    private final String nodeId;

    public UnitNodeStatus(String id, Version version, DeploymentStatus status, UUID opId, String nodeId) {
        super(id, version, status, opId);
        this.nodeId = nodeId;
    }

    public String nodeId() {
        return this.nodeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnitNodeStatus that = (UnitNodeStatus)o;
        return this.nodeId != null ? this.nodeId.equals(that.nodeId) : that.nodeId == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return S.toString(UnitNodeStatus.class, this, super.toString());
    }

    public static byte[] serialize(UnitNodeStatus status) {
        return SerializeUtils.serialize(new Object[]{status.id(), status.version(), status.status(), status.opId(), status.nodeId});
    }

    public static UnitNodeStatus deserialize(byte @Nullable [] value) {
        if (value == null || value.length == 0) {
            return new UnitNodeStatus(null, null, null, null, null);
        }
        String[] values = SerializeUtils.deserialize(value);
        String id = SerializeUtils.checkElement(values, 0) ? SerializeUtils.decode(values[0]) : null;
        Version version = SerializeUtils.deserializeVersion(values, 1);
        DeploymentStatus status = SerializeUtils.deserializeStatus(values, 2);
        UUID opId = SerializeUtils.deserializeUuid(values, 3);
        String nodeId = SerializeUtils.checkElement(values, 4) ? SerializeUtils.decode(values[4]) : null;
        return new UnitNodeStatus(id, version, status, opId, nodeId);
    }
}

