/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryHolder;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;

@GridInternal
@GridVisorManagementTask
public class VisorQueryTask
extends VisorOneNodeTask<VisorQueryTaskArg, VisorEither<VisorQueryResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryJob job(VisorQueryTaskArg arg) {
        return new VisorQueryJob(arg, this.debug);
    }

    private static class VisorQueryJob
    extends VisorJob<VisorQueryTaskArg, VisorEither<VisorQueryResult>> {
        private static final long serialVersionUID = 0L;

        private VisorQueryJob(VisorQueryTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorQueryResult> run(VisorQueryTaskArg arg) {
            try {
                UUID nid = this.ignite.localNode().id();
                GridQueryCancel cancel = new GridQueryCancel();
                ConcurrentMap<String, VisorQueryHolder> storage = this.ignite.cluster().nodeLocalMap();
                VisorQueryHolder holder = new VisorQueryHolder(true, null, cancel);
                storage.put(holder.getQueryID(), holder);
                VisorQueryUtils.scheduleQueryStart(this.ignite, holder, arg, cancel);
                return new VisorEither<VisorQueryResult>(new VisorQueryResult(nid, holder.getQueryID(), null, null, false, 0L));
            }
            catch (Throwable e) {
                return new VisorEither<VisorQueryResult>(new VisorExceptionWrapper(e));
            }
        }

        public String toString() {
            return S.toString(VisorQueryJob.class, this);
        }
    }
}

