/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeDeviceUsingTemplateVisitor;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeDeviceVisitor;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorFactory;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorWithLimitOffsetWrapper;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class ClusterSchemaTree
implements ISchemaTree {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ClusterSchemaTree.class);
    private static final ClusterTemplateManager templateManager = ClusterTemplateManager.getInstance();
    private Set<String> databases;
    private final SchemaNode root;
    private boolean hasLogicalMeasurementPath = false;
    private boolean hasNormalTimeSeries = false;
    private Map<Integer, Template> templateMap = new HashMap<Integer, Template>();
    private long ramBytesUsed;

    public ClusterSchemaTree() {
        this.root = new SchemaInternalNode("root");
    }

    public ClusterSchemaTree(SchemaNode root) {
        this.root = root;
    }

    public void setTemplateMap(Map<Integer, Template> templateMap) {
        this.templateMap = templateMap;
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        try (SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = SchemaTreeVisitorFactory.createSchemaTreeMeasurementVisitor(this.root, pathPattern, isPrefixMatch, slimit, soffset);){
            visitor.setTemplateMap(this.templateMap);
            Pair pair = new Pair(visitor.getAllResult(), (Object)visitor.getNextOffset());
            return pair;
        }
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern) {
        return this.searchMeasurementPaths(pathPattern, 0, 0, false);
    }

    public List<DeviceSchemaInfo> getAllDevices() {
        return this.getMatchedDevices(SchemaConstant.ALL_MATCH_PATTERN);
    }

    @Override
    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern) {
        return this.getMatchedDevices(pathPattern, false);
    }

    private List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) {
        try (SchemaTreeDeviceVisitor visitor = SchemaTreeVisitorFactory.createSchemaTreeDeviceVisitor(this.root, pathPattern, isPrefixMatch);){
            List<DeviceSchemaInfo> list = visitor.getAllResult();
            return list;
        }
    }

    private IMeasurementSchemaInfo getMeasurementSchemaInfo(SchemaEntityNode entityNode, String measurement) {
        SchemaNode node = entityNode.getChild(measurement);
        if (node != null && node.isMeasurement()) {
            return node.getAsMeasurementNode();
        }
        Template template = this.templateMap.get(entityNode.getTemplateId());
        if (template != null && template.getSchemaMap().containsKey(measurement)) {
            return new MeasurementSchemaInfo(measurement, template.getSchema(measurement), null, null, null);
        }
        return null;
    }

    @Override
    public DeviceSchemaInfo searchDeviceSchemaInfo(PartialPath devicePath, List<String> measurements) {
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                return null;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur == null || !cur.isEntity()) {
            return null;
        }
        SchemaEntityNode entityNode = cur.getAsEntityNode();
        ArrayList<IMeasurementSchemaInfo> measurementSchemaInfoList = new ArrayList<IMeasurementSchemaInfo>();
        for (String measurement : measurements) {
            measurementSchemaInfoList.add(this.getMeasurementSchemaInfo(entityNode, measurement));
        }
        return new DeviceSchemaInfo(devicePath, entityNode.isAligned(), entityNode.getTemplateId(), measurementSchemaInfoList);
    }

    public List<Integer> compute(ISchemaComputation schemaComputation, List<Integer> indexOfTargetMeasurements) {
        PartialPath devicePath = schemaComputation.getDevicePath();
        String[] measurements = schemaComputation.getMeasurements();
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                return indexOfTargetMeasurements;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur == null || !cur.isEntity()) {
            return indexOfTargetMeasurements;
        }
        SchemaEntityNode entityNode = cur.getAsEntityNode();
        boolean firstNonViewMeasurement = true;
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        for (int index : indexOfTargetMeasurements) {
            IMeasurementSchemaInfo measurementSchemaInfo = this.getMeasurementSchemaInfo(entityNode, measurements[index]);
            if (measurementSchemaInfo == null) {
                indexOfMissingMeasurements.add(index);
                continue;
            }
            if (firstNonViewMeasurement && !measurementSchemaInfo.isLogicalView()) {
                schemaComputation.computeDevice(cur.getAsEntityNode().isAligned());
                firstNonViewMeasurement = false;
            }
            schemaComputation.computeMeasurement(index, measurementSchemaInfo);
        }
        return indexOfMissingMeasurements;
    }

    public void computeSourceOfLogicalView(ISchemaComputation schemaComputation, List<Integer> indexOfTargetLogicalView) throws SemanticException {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return;
        }
        List<LogicalViewSchema> logicalViewSchemaList = schemaComputation.getLogicalViewSchemaList();
        for (Integer index : indexOfTargetLogicalView) {
            LogicalViewSchema logicalViewSchema = logicalViewSchemaList.get(index);
            PartialPath fullPath = logicalViewSchema.getSourcePathIfWritable();
            Pair<List<MeasurementPath>, Integer> searchResult = this.searchMeasurementPaths(fullPath);
            List measurementPathList = (List)searchResult.left;
            if (measurementPathList.isEmpty()) {
                throw new SemanticException((Throwable)((Object)new PathNotExistException(fullPath.getFullPath(), schemaComputation.getDevicePath().concatNode(logicalViewSchema.getMeasurementId()).getFullPath())));
            }
            if (measurementPathList.size() > 1) {
                throw new SemanticException(String.format("The source paths [%s] of view [%s] are multiple.", fullPath.getFullPath(), schemaComputation.getDevicePath().concatNode(logicalViewSchema.getMeasurementId())));
            }
            Integer realIndex = schemaComputation.getIndexListOfLogicalViewPaths().get(index);
            MeasurementPath measurementPath = (MeasurementPath)measurementPathList.get(0);
            schemaComputation.computeMeasurementOfView(realIndex, new MeasurementSchemaInfo(measurementPath.getMeasurement(), measurementPath.getMeasurementSchema(), null, measurementPath.getTagMap(), null), measurementPath.isUnderAlignedEntity());
        }
    }

    public void appendTemplateDevice(PartialPath devicePath, boolean isAligned, int templateId, Template template) {
        SchemaNode child;
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length - 1; ++i) {
            child = cur.getChild(nodes[i]);
            if (child == null) {
                child = new SchemaInternalNode(nodes[i]);
                cur.addChild(nodes[i], child);
            }
            cur = child;
        }
        String deviceName = nodes[nodes.length - 1];
        child = cur.getChild(deviceName);
        if (child == null) {
            SchemaEntityNode entityNode = new SchemaEntityNode(deviceName);
            entityNode.setAligned(isAligned);
            entityNode.setTemplateId(templateId);
            cur.addChild(deviceName, entityNode);
        } else if (child.isEntity()) {
            child.getAsEntityNode().setTemplateId(templateId);
            child.getAsEntityNode().setAligned(isAligned);
        } else {
            SchemaEntityNode entityNode = new SchemaEntityNode(deviceName);
            entityNode.setAligned(isAligned);
            entityNode.setTemplateId(templateId);
            cur.replaceChild(deviceName, entityNode);
        }
        if (template != null) {
            this.templateMap.putIfAbsent(templateId, template);
        }
    }

    public void appendMeasurementPaths(List<MeasurementPath> measurementPathList) {
        for (MeasurementPath measurementPath : measurementPathList) {
            this.appendSingleMeasurementPath(measurementPath);
        }
    }

    public void appendSingleMeasurementPath(MeasurementPath measurementPath) {
        this.appendSingleMeasurement((PartialPath)measurementPath, measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), null, measurementPath.isMeasurementAliasExists() ? measurementPath.getMeasurementAlias() : null, measurementPath.isUnderAlignedEntity());
    }

    public void appendSingleMeasurement(PartialPath path, IMeasurementSchema schema, Map<String, String> tagMap, Map<String, String> attributeMap, String alias, boolean isAligned) {
        String[] nodes = path.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            SchemaEntityNode entityNode;
            SchemaNode child = cur.getChild(nodes[i]);
            if (child == null) {
                if (i == nodes.length - 1) {
                    SchemaMeasurementNode measurementNode = new SchemaMeasurementNode(nodes[i], schema);
                    if (alias != null) {
                        measurementNode.setAlias(alias);
                        cur.getAsEntityNode().addAliasChild(alias, measurementNode);
                    }
                    measurementNode.setTagMap(tagMap);
                    measurementNode.setAttributeMap(attributeMap);
                    child = measurementNode;
                    if (schema.isLogicalView()) {
                        this.hasLogicalMeasurementPath = true;
                    }
                } else if (i == nodes.length - 2) {
                    entityNode = new SchemaEntityNode(nodes[i]);
                    entityNode.setAligned(isAligned);
                    child = entityNode;
                } else {
                    child = new SchemaInternalNode(nodes[i]);
                }
                cur.addChild(nodes[i], child);
            } else if (i == nodes.length - 2 && !child.isEntity()) {
                entityNode = new SchemaEntityNode(nodes[i]);
                cur.replaceChild(nodes[i], entityNode);
                if (!entityNode.isAligned()) {
                    entityNode.setAligned(isAligned);
                }
                child = entityNode;
            }
            cur = child;
        }
        this.hasNormalTimeSeries = true;
    }

    @Override
    public void mergeSchemaTree(ISchemaTree schemaTree) {
        if (schemaTree instanceof ClusterSchemaTree) {
            this.mergeSchemaTree((ClusterSchemaTree)schemaTree);
        }
    }

    @Override
    public boolean hasNormalTimeSeries() {
        return this.hasNormalTimeSeries;
    }

    @Override
    public List<Template> getUsingTemplates() {
        return new ArrayList<Template>(this.templateMap.values());
    }

    @Override
    public List<PartialPath> getDeviceUsingTemplate(int templateId) {
        try (SchemaTreeDeviceUsingTemplateVisitor visitor = SchemaTreeVisitorFactory.createSchemaTreeDeviceUsingTemplateVisitor(this.root, SchemaConstant.ALL_MATCH_PATTERN, templateId);){
            List<PartialPath> list = visitor.getAllResult();
            return list;
        }
    }

    public void mergeSchemaTree(ClusterSchemaTree schemaTree) {
        this.hasLogicalMeasurementPath = this.hasLogicalMeasurementPath || schemaTree.hasLogicalViewMeasurement();
        this.traverseAndMerge(this.root, null, schemaTree.root);
        this.templateMap.putAll(schemaTree.templateMap);
        this.hasNormalTimeSeries |= schemaTree.hasNormalTimeSeries;
    }

    @Override
    public void removeLogicalView() {
        this.removeLogicViewMeasurement(this.root);
    }

    private void removeLogicViewMeasurement(SchemaNode parent) {
        if (parent.isMeasurement()) {
            return;
        }
        Map<String, SchemaNode> children = parent.getChildren();
        ArrayList<String> childrenToBeRemoved = new ArrayList<String>();
        for (Map.Entry<String, SchemaNode> entry : children.entrySet()) {
            SchemaNode child = entry.getValue();
            if (child.isMeasurement() && child.getAsMeasurementNode().isLogicalView()) {
                childrenToBeRemoved.add(entry.getKey());
                continue;
            }
            this.removeLogicViewMeasurement(child);
        }
        for (String key : childrenToBeRemoved) {
            parent.removeChild(key);
        }
    }

    private void traverseAndMerge(SchemaNode thisNode, SchemaNode thisParent, SchemaNode thatNode) {
        SchemaEntityNode entityNode;
        if (thatNode.isEntity() && thatNode.getAsEntityNode().getTemplateId() != -1) {
            if (thisNode.isEntity()) {
                entityNode = thisNode.getAsEntityNode();
            } else {
                entityNode = new SchemaEntityNode(thisNode.getName());
                thisParent.replaceChild(thisNode.getName(), entityNode);
                thisNode = entityNode;
            }
            entityNode.setTemplateId(thatNode.getAsEntityNode().getTemplateId());
        }
        for (SchemaNode thatChild : thatNode.getChildren().values()) {
            SchemaNode thisChild = thisNode.getChild(thatChild.getName());
            if (thisChild == null) {
                SchemaMeasurementNode measurementNode;
                thisNode.addChild(thatChild.getName(), thatChild);
                if (!thatChild.isMeasurement()) continue;
                SchemaEntityNode thatEntity = thatNode.getAsEntityNode();
                if (thisNode.isEntity()) {
                    entityNode = thisNode.getAsEntityNode();
                } else {
                    entityNode = new SchemaEntityNode(thisNode.getName());
                    thisParent.replaceChild(thisNode.getName(), entityNode);
                    thisNode = entityNode;
                }
                if (!entityNode.isAligned()) {
                    entityNode.setAligned(thatEntity.isAligned());
                }
                if ((measurementNode = thatChild.getAsMeasurementNode()).getAlias() == null) continue;
                entityNode.addAliasChild(measurementNode.getAlias(), measurementNode);
                continue;
            }
            this.traverseAndMerge(thisChild, thisNode, thatChild);
        }
    }

    @Override
    public boolean hasLogicalViewMeasurement() {
        return this.hasLogicalMeasurementPath;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.root.serialize(outputStream);
    }

    public Iterator<SchemaNode> getIteratorForSerialize() {
        return new SchemaNodePostOrderIterator(this.root);
    }

    public long ramBytesUsed() {
        if (this.ramBytesUsed > 0L) {
            return this.ramBytesUsed;
        }
        this.ramBytesUsed = this.root.ramBytesUsed() + SHALLOW_SIZE + RamUsageEstimator.sizeOfMapWithKnownShallowSize(this.templateMap, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP_ENTRY);
        return this.ramBytesUsed;
    }

    public void setRamBytesUsed(long ramBytesUsed) {
        this.ramBytesUsed = ramBytesUsed;
    }

    public static ClusterSchemaTree deserialize(InputStream inputStream) throws IOException {
        SchemaNodeBatchDeserializer schemaNodeBatchDeserializer = new SchemaNodeBatchDeserializer();
        schemaNodeBatchDeserializer.deserializeFromBatch(inputStream);
        return schemaNodeBatchDeserializer.finish();
    }

    @Override
    public String getBelongedDatabase(String pathName) {
        for (String database : this.databases) {
            if (!PathUtils.isStartWith((String)pathName, (String)database)) continue;
            return database;
        }
        throw new SemanticException("No matched database. Please check the path " + pathName);
    }

    @Override
    public String getBelongedDatabase(PartialPath path) {
        return this.getBelongedDatabase(path.getFullPath());
    }

    @Override
    public Set<String> getDatabases() {
        return this.databases;
    }

    @Override
    public void setDatabases(Set<String> databases) {
        this.databases = databases;
    }

    SchemaNode getRoot() {
        return this.root;
    }

    @Override
    public boolean isEmpty() {
        return this.root.getChildren() == null || this.root.getChildren().isEmpty();
    }

    private static class SchemaNodePostOrderIterator
    implements Iterator<SchemaNode> {
        private final Deque<Pair<SchemaNode, Iterator<SchemaNode>>> stack = new ArrayDeque<Pair<SchemaNode, Iterator<SchemaNode>>>();
        private SchemaNode nextNode;

        public SchemaNodePostOrderIterator(SchemaNode root) {
            this.stack.push((Pair<SchemaNode, Iterator<SchemaNode>>)new Pair((Object)root, root.getChildrenIterator()));
            this.prepareNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public SchemaNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SchemaNode result = this.nextNode;
            this.prepareNext();
            return result;
        }

        private void prepareNext() {
            this.nextNode = null;
            while (!this.stack.isEmpty()) {
                Pair<SchemaNode, Iterator<SchemaNode>> pair = this.stack.peek();
                SchemaNode currentNode = (SchemaNode)pair.getLeft();
                Iterator childrenIterator = (Iterator)pair.getRight();
                if (childrenIterator.hasNext()) {
                    SchemaNode child = (SchemaNode)childrenIterator.next();
                    this.stack.push((Pair<SchemaNode, Iterator<SchemaNode>>)new Pair((Object)child, child.getChildrenIterator()));
                    continue;
                }
                this.stack.pop();
                this.nextNode = currentNode;
                return;
            }
        }
    }

    public static class SchemaNodeBatchDeserializer {
        private byte nodeType;
        private int childNum;
        private final Deque<SchemaNode> stack = new ArrayDeque<SchemaNode>();
        private SchemaNode child;
        private boolean hasLogicalView = false;
        private boolean hasNormalTimeSeries = false;
        private Map<Integer, Template> templateMap = new HashMap<Integer, Template>();
        private boolean isFirstBatch = true;

        public boolean isFirstBatch() {
            return this.isFirstBatch;
        }

        public void deserializeFromBatch(InputStream inputStream) throws IOException {
            this.isFirstBatch = false;
            while (inputStream.available() > 0) {
                SchemaInternalNode internalNode;
                this.nodeType = ReadWriteIOUtils.readByte((InputStream)inputStream);
                if (this.nodeType == 2) {
                    SchemaMeasurementNode measurementNode = SchemaMeasurementNode.deserialize(inputStream);
                    this.stack.push(measurementNode);
                    if (measurementNode.isLogicalView()) {
                        this.hasLogicalView = true;
                    }
                    this.hasNormalTimeSeries = true;
                    continue;
                }
                if (this.nodeType == 1) {
                    internalNode = SchemaEntityNode.deserialize(inputStream);
                    int templateId = internalNode.getAsEntityNode().getTemplateId();
                    if (templateId != -1) {
                        this.templateMap.putIfAbsent(templateId, templateManager.getTemplate(templateId));
                    }
                } else {
                    internalNode = SchemaInternalNode.deserialize(inputStream);
                }
                this.childNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                while (this.childNum > 0) {
                    SchemaMeasurementNode measurementNode;
                    this.child = this.stack.pop();
                    internalNode.addChild(this.child.getName(), this.child);
                    if (this.child.isMeasurement() && (measurementNode = this.child.getAsMeasurementNode()).getAlias() != null) {
                        internalNode.getAsEntityNode().addAliasChild(measurementNode.getAlias(), measurementNode);
                    }
                    --this.childNum;
                }
                this.stack.push(internalNode);
            }
        }

        public ClusterSchemaTree finish() {
            try {
                ClusterSchemaTree result = new ClusterSchemaTree(this.stack.poll());
                result.templateMap = this.templateMap;
                result.hasLogicalMeasurementPath = this.hasLogicalView;
                result.hasNormalTimeSeries = this.hasNormalTimeSeries;
                ClusterSchemaTree clusterSchemaTree = result;
                return clusterSchemaTree;
            }
            finally {
                this.reset();
            }
        }

        private void reset() {
            this.nodeType = 0;
            this.childNum = 0;
            this.stack.clear();
            this.child = null;
            this.hasLogicalView = false;
            this.hasNormalTimeSeries = false;
            this.templateMap = new HashMap<Integer, Template>();
            this.isFirstBatch = true;
        }
    }
}

