/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;

public class Map2<K, V>
implements Iterable<K> {
    private final Map<K, V> map1;
    private final Map2<K, V> map2;

    public Map2(Map<K, V> map1, Map2<K, V> map2) {
        this.map1 = map1;
        this.map2 = map2;
    }

    public boolean containsKey(K key) {
        if (this.map1 == null) {
            return false;
        }
        if (this.map1.containsKey(key)) {
            return true;
        }
        if (this.map2 != null) {
            return this.map2.containsKey(key);
        }
        return false;
    }

    public V get(K key) {
        if (this.map1 == null) {
            return null;
        }
        V v = this.map1.get(key);
        if (v != null) {
            return v;
        }
        if (this.map2 != null) {
            return this.map2.get(key);
        }
        return null;
    }

    public void put(K key, V value) {
        if (this.map1 == null) {
            throw new IllegalArgumentException("read-only empty map");
        }
        if (this.map2 != null && this.map2.containsKey(key)) {
            throw new IllegalArgumentException("Parent map already contains " + String.valueOf(key));
        }
        this.map1.put(key, value);
    }

    @Override
    public Iterator<K> iterator() {
        if (this.map1 == null) {
            return Iter.nullIterator();
        }
        Iter<K> iter1 = Iter.iter(this.map1.keySet().iterator());
        if (this.map2 == null) {
            return iter1;
        }
        return iter1.append(this.map2.iterator());
    }

    public boolean isEmpty() {
        if (this.map1 == null) {
            return true;
        }
        boolean x = this.map1.isEmpty();
        if (!x) {
            return false;
        }
        if (this.map2 != null) {
            return this.map2.isEmpty();
        }
        return true;
    }

    public int size() {
        if (this.map1 == null) {
            return 0;
        }
        int x = this.map1.size();
        if (this.map2 != null) {
            x += this.map2.size();
        }
        return x;
    }
}

