/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import jakarta.servlet.ServletOutputStream;
import org.apache.jena.fuseki.metrics.FusekiMetrics;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class PrometheusMetricsProvider
implements MetricsProvider {
    private PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);

    public PrometheusMetricsProvider() {
        this.meterRegistry.config().commonTags("application", "fuseki");
        FusekiMetrics.registerMetrics(this.meterRegistry);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public void scrape(HttpAction action) {
        try (ServletOutputStream out = action.getResponseOutputStream();){
            ServletOps.success(action);
            action.setResponseContentType("text/plain");
            action.setResponseCharacterEncoding("utf-8");
            out.write(this.meterRegistry.scrape().getBytes());
        }
        catch (Throwable t) {
            ServletOps.errorOccurred(t);
        }
    }
}

