/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.session.mgt;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.web.session.HttpServletSession;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.apache.shiro.web.util.WebUtils;

public class ServletContainerSessionManager
implements WebSessionManager {
    @Override
    public Session start(SessionContext context2) throws AuthorizationException {
        return this.createSession(context2);
    }

    @Override
    public Session getSession(SessionKey key) throws SessionException {
        if (!WebUtils.isHttp(key)) {
            String msg = "SessionKey must be an HTTP compatible implementation.";
            throw new IllegalArgumentException(msg);
        }
        HttpServletRequest request = WebUtils.getHttpRequest(key);
        Session session = null;
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            session = this.createSession(httpSession, request.getRemoteHost());
        }
        return session;
    }

    private String getHost(SessionContext context2) {
        ServletRequest request;
        String host = context2.getHost();
        if (host == null && (request = WebUtils.getRequest(context2)) != null) {
            host = request.getRemoteHost();
        }
        return host;
    }

    protected Session createSession(SessionContext sessionContext) throws AuthorizationException {
        if (!WebUtils.isHttp(sessionContext)) {
            String msg = "SessionContext must be an HTTP compatible implementation.";
            throw new IllegalArgumentException(msg);
        }
        HttpServletRequest request = WebUtils.getHttpRequest(sessionContext);
        HttpSession httpSession = request.getSession();
        String host = this.getHost(sessionContext);
        return this.createSession(httpSession, host);
    }

    protected Session createSession(HttpSession httpSession, String host) {
        return new HttpServletSession(httpSession, host);
    }

    @Override
    public boolean isServletContainerSessions() {
        return true;
    }
}

