/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JCodeStatement;
import org.exolab.javasource.JSourceWriter;

public final class JSourceCode {
    public static final int DEFAULT_INDENT_SIZE = 4;
    private Vector _source = null;
    private short _indentSize;
    private short _currentIndent = this._indentSize = (short)4;

    public JSourceCode() {
        this._source = new Vector();
    }

    public JSourceCode(String sourceCode) {
        this();
        this._source.addElement(new JCodeStatement(sourceCode, this._currentIndent));
    }

    public void add(String statement) {
        JCodeStatement jcs = new JCodeStatement(statement, this._currentIndent);
        this._source.addElement(jcs);
    }

    public void add(String statement, short indentSize) {
        JCodeStatement jcs = new JCodeStatement(statement, indentSize);
        this._source.addElement(jcs);
    }

    public void addIndented(String statement) {
        this.indent();
        JCodeStatement jcs = new JCodeStatement(statement, this._currentIndent);
        this._source.addElement(jcs);
        this.unindent();
    }

    public void append(String segment) {
        if (this._source.isEmpty()) {
            this.add(segment);
        } else {
            JCodeStatement jcs = (JCodeStatement)this._source.lastElement();
            jcs.append(segment);
        }
    }

    public void clear() {
        this._source.removeAllElements();
    }

    public void copyInto(JSourceCode jsc) {
        for (int i = 0; i < this._source.size(); ++i) {
            jsc.addCodeStatement((JCodeStatement)this._source.elementAt(i));
        }
    }

    public void indent() {
        this._currentIndent = (short)(this._currentIndent + this._indentSize);
    }

    public boolean isEmpty() {
        return this._source.isEmpty();
    }

    public void print(JSourceWriter jsw) {
        for (int i = 0; i < this._source.size(); ++i) {
            jsw.writeln(this._source.elementAt(i).toString());
        }
    }

    public void unindent() {
        this._currentIndent = (short)(this._currentIndent - this._indentSize);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        for (int i = 0; i < this._source.size(); ++i) {
            sb.append(this._source.elementAt(i).toString());
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private void addCodeStatement(JCodeStatement jcs) {
        short indent = (short)(jcs.getIndent() + this._currentIndent - 4);
        this._source.addElement(new JCodeStatement(jcs.getStatement(), indent));
    }
}

