/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.TypeValidator;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryAclService
extends InMemoryAbstractServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryAclService.class.getName());

    public InMemoryAclService(StoreManager storeManager) {
        super(storeManager);
    }

    public Acl getAcl(CallContext context, String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug("start getAcl()");
        StoredObject so = this.validator.getAcl(context, repositoryId, objectId, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        int aclId = so instanceof DocumentVersion ? ((DocumentVersion)so).getParentDocument().getAclId() : so.getAclId();
        Acl acl = objectStore.getAcl(aclId);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return acl;
    }

    public Acl applyAcl(CallContext context, String repositoryId, String objectId, Acl aclAdd, Acl aclRemove, AclPropagation aclPropagation, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        Acl addAces = TypeValidator.expandAclMakros(context.getUsername(), aclAdd);
        Acl removeAces = TypeValidator.expandAclMakros(context.getUsername(), aclRemove);
        StoredObject so = this.validator.applyAcl(context, repositoryId, objectId, aclPropagation, extension);
        Acl acl = this.fStoreManager.getObjectStore(repositoryId).applyAcl(so, addAces, removeAces, aclPropagation, context.getUsername());
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return acl;
    }

    public Acl applyAcl(CallContext context, String repositoryId, String objectId, Acl acesParam, AclPropagation aclPropagation) {
        Acl aces = TypeValidator.expandAclMakros(context.getUsername(), acesParam);
        StoredObject so = this.validator.applyAcl(context, repositoryId, objectId);
        return this.fStoreManager.getObjectStore(repositoryId).applyAcl(so, aces, aclPropagation, context.getUsername());
    }
}

