/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LineMap;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class Tiny {
    static final String KEY_DEFAULT_ENABLED = "generateDefault";
    static final String KEY_DEFAULT_SNIPPET = "defaultSnippet";
    static final boolean DEF_DEFAULT_ENABLED = true;
    static final String DEF_DEFAULT_SNIPPET = "throw new java.lang.AssertionError($expression.name());";

    public static ErrorDescription flipEquals(HintContext ctx) {
        int selectEnd;
        int selectStart;
        int caret = ctx.getCaretLocation();
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree select = mit.getMethodSelect();
        switch (select.getKind()) {
            case MEMBER_SELECT: {
                int[] span = ctx.getInfo().getTreeUtilities().findNameSpan((MemberSelectTree)select);
                if (span == null) {
                    return null;
                }
                selectStart = span[0];
                selectEnd = span[1];
                break;
            }
            case IDENTIFIER: {
                selectStart = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), select);
                selectEnd = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), select);
                break;
            }
            default: {
                Logger.getLogger(Tiny.class.getName()).log(Level.FINE, "flipEquals: unexpected method select kind: {0}", (Object)select.getKind());
                return null;
            }
        }
        if (selectStart > caret || selectEnd < caret) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_flipEquals");
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_flipEquals");
        String fixPattern = ctx.getVariables().containsKey("$this") ? "$other.equals($this)" : "$other.equals(this)";
        Fix fix = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), fixPattern);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fix);
    }

    public static ErrorDescription convertToDifferentBase(HintContext ctx) {
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), ctx.getPath().getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), ctx.getPath().getLeaf());
        String code = ctx.getInfo().getText().substring(start, end);
        int currentRadix = 10;
        if (code.startsWith("0x") || code.startsWith("0X")) {
            currentRadix = 16;
        } else if (code.startsWith("0b") || code.startsWith("0B")) {
            currentRadix = 2;
        } else if (code.startsWith("0") || code.startsWith("0")) {
            currentRadix = 8;
        }
        LinkedList<Fix> fixes = new LinkedList<Fix>();
        if (currentRadix != 16) {
            fixes.add(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0x", 16).toEditorFix());
        }
        if (currentRadix != 10) {
            fixes.add(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "", 10).toEditorFix());
        }
        if (currentRadix != 8) {
            fixes.add(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0", 8).toEditorFix());
        }
        if (currentRadix != 2 && ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0) {
            fixes.add(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0b", 2).toEditorFix());
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(Tiny.class, "ERR_convertToDifferentBase"), fixes.toArray(new Fix[0]));
    }

    public static ErrorDescription splitDeclaration(HintContext ctx) {
        Tree.Kind parentKind = ctx.getPath().getParentPath().getLeaf().getKind();
        if (parentKind != Tree.Kind.BLOCK && parentKind != Tree.Kind.CASE) {
            return null;
        }
        if (ctx.getInfo().getTreeUtilities().isVarType(ctx.getPath())) {
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_splitDeclaration");
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix();
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fix);
    }

    public static ErrorDescription fillSwitch(HintContext ctx) {
        String errMessage;
        String defaultTemplate;
        int caret = ctx.getCaretLocation();
        SwitchTree st = (SwitchTree)ctx.getPath().getLeaf();
        int switchStart = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getPath().getCompilationUnit(), st);
        LineMap lm = ctx.getPath().getCompilationUnit().getLineMap();
        if (lm.getLineNumber(caret) != lm.getLineNumber(switchStart)) {
            return null;
        }
        TreePath expression = ctx.getVariables().get("$expression");
        Element possibleEnumElement = ctx.getInfo().getTypes().asElement(ctx.getInfo().getTrees().getTypeMirror(expression));
        if (possibleEnumElement == null || !possibleEnumElement.getKind().isClass()) {
            return null;
        }
        TypeElement enumType = (TypeElement)possibleEnumElement;
        ArrayList<VariableElement> enumConstants = new ArrayList<VariableElement>(enumType.getEnclosedElements().size());
        for (Element element : enumType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            enumConstants.add((VariableElement)element);
        }
        boolean hasDefault = false;
        for (TreePath treePath : ctx.getMultiVariables().get("$cases$")) {
            CaseTree ct = (CaseTree)treePath.getLeaf();
            if (ct.getExpression() == null) {
                hasDefault = true;
                continue;
            }
            enumConstants.remove(ctx.getInfo().getTrees().getElement(new TreePath(treePath, ct.getExpression())));
        }
        boolean bl = ctx.getPreferences().getBoolean(KEY_DEFAULT_ENABLED, true);
        if (enumConstants.isEmpty() && (hasDefault || !bl)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumConstants.size());
        for (VariableElement constant : enumConstants) {
            arrayList.add(constant.getSimpleName().toString());
        }
        String string = defaultTemplate = bl ? ctx.getPreferences().get(KEY_DEFAULT_SNIPPET, DEF_DEFAULT_SNIPPET) : null;
        String string2 = enumConstants.isEmpty() ? "ERR_Tiny.fillSwitchDefault" : (errMessage = !hasDefault && bl ? "ERR_Tiny.fillSwitchCasesAndDefault" : "ERR_Tiny.fillSwitchCases");
        String fixMessage = enumConstants.isEmpty() ? "FIX_Tiny.fillSwitchDefault" : (!hasDefault && bl ? "FIX_Tiny.fillSwitchCasesAndDefault" : "FIX_Tiny.fillSwitchCases");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(Tiny.class, errMessage), new AddSwitchCasesImpl(ctx.getInfo(), ctx.getPath(), fixMessage, arrayList, defaultTemplate).toEditorFix());
    }

    public static ErrorDescription inlineRedundantVar(HintContext ctx) {
        Element element;
        TreePath var = ctx.getVariables().get("$var");
        if (var != null && (element = ctx.getInfo().getTrees().getElement(var)) != null && element.getKind() == ElementKind.LOCAL_VARIABLE) {
            TreePath var2 = ctx.getVariables().get("$var2");
            Collection<? extends TreePath> stats = ctx.getMultiVariables().get("$statements$");
            if (var2 != null) {
                if (stats != null && !Utilities.isReferencedIn(ctx.getInfo(), var, stats)) {
                    Fix fix = JavaFixUtilities.rewriteFix(ctx, NbBundle.getMessage(Tiny.class, "FIX_Tiny.inlineRedundantVar", element.getSimpleName()), ctx.getPath(), "$type2 $var2 = $init; $statements$");
                    return ErrorDescriptionFactory.forName(ctx, var, NbBundle.getMessage(Tiny.class, "ERR_Tiny.inlineRedundantVar", element.getSimpleName()), fix);
                }
            } else {
                Fix fix = JavaFixUtilities.rewriteFix(ctx, NbBundle.getMessage(Tiny.class, "FIX_Tiny.inlineRedundantVar", element.getSimpleName()), ctx.getPath(), "return $init;");
                return ErrorDescriptionFactory.forName(ctx, var, NbBundle.getMessage(Tiny.class, "ERR_Tiny.inlineRedundantVar", element.getSimpleName()), fix);
            }
        }
        return null;
    }

    private static final class ToDifferentRadixFixImpl
    extends JavaFix {
        private final String prefix;
        private final int radix;

        public ToDifferentRadixFixImpl(CompilationInfo info, TreePath tp, String prefix, int radix) {
            super(info, tp);
            this.prefix = prefix;
            this.radix = radix;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(Tiny.class, "FIX_convertToDifferentBase_" + this.radix);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            Object target;
            String suffix;
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            LiteralTree leaf = (LiteralTree)tp.getLeaf();
            if (leaf.getKind() == Tree.Kind.INT_LITERAL) {
                suffix = "";
                int value = ((Number)leaf.getValue()).intValue();
                switch (this.radix) {
                    case 2: {
                        target = Integer.toBinaryString(value);
                        break;
                    }
                    case 8: {
                        target = Integer.toOctalString(value);
                        break;
                    }
                    case 10: {
                        target = Integer.toString(value);
                        break;
                    }
                    case 16: {
                        target = Integer.toHexString(value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else if (leaf.getKind() == Tree.Kind.LONG_LITERAL) {
                int end = (int)wc.getTrees().getSourcePositions().getEndPosition(wc.getCompilationUnit(), leaf);
                suffix = wc.getText().substring(end - 1, end);
                long value = ((Number)leaf.getValue()).longValue();
                switch (this.radix) {
                    case 2: {
                        target = Long.toBinaryString(value);
                        break;
                    }
                    case 8: {
                        target = Long.toOctalString(value);
                        break;
                    }
                    case 10: {
                        target = Long.toString(value);
                        break;
                    }
                    case 16: {
                        target = Long.toHexString(value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            target = this.prefix + (String)target + suffix;
            wc.rewrite(leaf, wc.getTreeMaker().Identifier((CharSequence)target));
        }
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(Tiny.class, "FIX_splitDeclaration");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Tree parent = tp.getParentPath().getLeaf();
            List<? extends StatementTree> statements = switch (parent.getKind()) {
                case Tree.Kind.BLOCK -> ((BlockTree)parent).getStatements();
                case Tree.Kind.CASE -> ((CaseTree)parent).getStatements();
                default -> throw new IllegalStateException(parent.getKind().name());
            };
            VariableTree var = (VariableTree)tp.getLeaf();
            int current = statements.indexOf(tp.getLeaf());
            TreeMaker make = wc.getTreeMaker();
            ArrayList<StatementTree> newStatements = new ArrayList<StatementTree>();
            newStatements.addAll(statements.subList(0, current));
            newStatements.add(make.asReplacementOf(make.Variable(var.getModifiers(), var.getName(), var.getType(), null), var));
            newStatements.add(make.ExpressionStatement(make.Assignment(make.Identifier(var.getName()), var.getInitializer())));
            newStatements.addAll(statements.subList(current + 1, statements.size()));
            wc.rewrite(parent, switch (parent.getKind()) {
                case Tree.Kind.BLOCK -> make.Block(newStatements, ((BlockTree)parent).isStatic());
                case Tree.Kind.CASE -> make.Case(((CaseTree)parent).getExpression(), newStatements);
                default -> throw new IllegalStateException(parent.getKind().name());
            });
        }
    }

    private static final class AddSwitchCasesImpl
    extends JavaFix {
        private final String text;
        private final List<String> names;
        private final String defaultTemplate;

        public AddSwitchCasesImpl(CompilationInfo info, TreePath tp, String text, List<String> names, String defaultTemplate) {
            super(info, tp);
            this.text = text;
            this.names = names;
            this.defaultTemplate = defaultTemplate;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(Tiny.class, this.text);
        }

        @Override
        protected void performRewrite(final JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            final TreeMaker make = wc.getTreeMaker();
            final TreePath tp = ctx.getPath();
            SwitchTree st = (SwitchTree)tp.getLeaf();
            int insertIndex = 0;
            boolean hadDefault = false;
            for (CaseTree caseTree : st.getCases()) {
                if (caseTree.getExpression() == null) {
                    hadDefault = true;
                    break;
                }
                ++insertIndex;
            }
            for (String string : this.names) {
                st = make.insertSwitchCase(st, insertIndex++, make.Case(make.Identifier(string), Collections.singletonList(make.Break(null))));
            }
            if (!hadDefault && this.defaultTemplate != null) {
                StatementTree stmt = ctx.getWorkingCopy().getTreeUtilities().parseStatement(this.defaultTemplate, new SourcePositions[1]);
                Scope scope = ctx.getWorkingCopy().getTrees().getScope(tp);
                ctx.getWorkingCopy().getTreeUtilities().attributeTree(stmt, scope);
                st = GeneratorUtilities.get(ctx.getWorkingCopy()).importFQNs(make.addSwitchCase(st, make.Case(null, Collections.singletonList(stmt))));
                new ErrorAwareTreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        if (node.getName().contentEquals("$expression")) {
                            ExpressionTree expression = ((SwitchTree)tp.getLeaf()).getExpression();
                            if (expression.getKind() == Tree.Kind.PARENTHESIZED) {
                                expression = ((ParenthesizedTree)expression).getExpression();
                            }
                            if (JavaFixUtilities.requiresParenthesis(expression, node, this.getCurrentPath().getParentPath().getLeaf())) {
                                expression = make.Parenthesized(expression);
                            }
                            ctx.getWorkingCopy().rewrite(node, expression);
                        }
                        return (Void)super.visitIdentifier(node, p);
                    }
                }.scan(new TreePath(ctx.getPath(), st), (Void)null);
            }
            wc.rewrite(tp.getLeaf(), st);
        }
    }
}

