/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ReflectionUtils;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.mock.MockProcessContext;
import org.apache.nifi.mock.MockProcessorInitializationContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;

public class ProcessorInitializer
implements ConfigurableComponentInitializer {
    private final ExtensionManager extensionManager;

    public ProcessorInitializer(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void initialize(ConfigurableComponent component) {
        Processor processor = (Processor)component;
        MockProcessorInitializationContext initializationContext = new MockProcessorInitializationContext();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), initializationContext.getIdentifier());){
            processor.initialize((ProcessorInitializationContext)initializationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown(ConfigurableComponent component) {
        Processor processor = (Processor)component;
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), component.getIdentifier());){
            MockComponentLogger logger = new MockComponentLogger();
            MockProcessContext context = new MockProcessContext();
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, processor, logger, context);
        }
        finally {
            this.extensionManager.removeInstanceClassLoader(component.getIdentifier());
        }
    }
}

