/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

public class ConfigVerificationResult {
    private final Outcome outcome;
    private final String verificationStepName;
    private final String explanation;

    private ConfigVerificationResult(Builder builder) {
        this.outcome = builder.outcome;
        this.verificationStepName = builder.verificationStepName;
        this.explanation = builder.explanation;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public String getVerificationStepName() {
        return this.verificationStepName;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String toString() {
        return "ConfigVerificationResult[outcome=" + String.valueOf((Object)this.outcome) + ", verificationStepName='" + this.verificationStepName + "', explanation='" + this.explanation + "']";
    }

    public static class Builder {
        private Outcome outcome = Outcome.SKIPPED;
        private String verificationStepName = "Unknown Step Name";
        private String explanation;

        public Builder outcome(Outcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder verificationStepName(String verificationStepName) {
            this.verificationStepName = verificationStepName;
            return this;
        }

        public Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public ConfigVerificationResult build() {
            return new ConfigVerificationResult(this);
        }
    }

    public static enum Outcome {
        SUCCESSFUL,
        FAILED,
        SKIPPED;

    }
}

