/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Set;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleVersionDependency;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.link.LinkableEntity;

@XmlRootElement
public class BundleVersion
extends LinkableEntity {
    @Valid
    @NotNull
    private BundleVersionMetadata versionMetadata;
    private Set<BundleVersionDependency> dependencies;
    private Bundle bundle;
    private Bucket bucket;

    @Schema(description="The metadata about this version of the extension bundle")
    public BundleVersionMetadata getVersionMetadata() {
        return this.versionMetadata;
    }

    public void setVersionMetadata(BundleVersionMetadata versionMetadata) {
        this.versionMetadata = versionMetadata;
    }

    @Schema(description="The set of other bundle versions that this version is dependent on", accessMode=Schema.AccessMode.READ_ONLY)
    public Set<BundleVersionDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<BundleVersionDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Schema(description="The bundle this version is for", accessMode=Schema.AccessMode.READ_ONLY)
    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @Schema(description="The bucket that the extension bundle belongs to")
    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @XmlTransient
    public String getFilename() {
        String filename = this.bundle.getArtifactId() + "-" + this.versionMetadata.getVersion();
        switch (this.bundle.getBundleType()) {
            case NIFI_NAR: {
                return filename + ".nar";
            }
            case MINIFI_CPP: {
                return filename;
            }
        }
        throw new IllegalStateException("Unknown bundle type: " + String.valueOf((Object)this.bundle.getBundleType()));
    }
}

