/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.util;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public class CryptoUtils {
    private static final String[] standardCryptoTransformations = new String[]{"AES/CBC/NoPadding", "AES/CBC/PKCS5Padding", "AES/ECB/NoPadding", "AES/ECB/PKCS5Padding", "DES/CBC/NoPadding", "DES/CBC/PKCS5Padding", "DES/ECB/NoPadding", "DES/ECB/PKCS5Padding", "DESede/CBC/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/ECB/NoPadding", "DESede/ECB/PKCS5Padding", "RSA/ECB/PKCS1Padding", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding"};

    public static Boolean isCryptoRestricted() {
        for (String transformation : standardCryptoTransformations) {
            try {
                return Cipher.getMaxAllowedKeyLength(transformation) < Integer.MAX_VALUE;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        return null;
    }
}

