/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.tenant;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class UpdateUser
extends AbstractNiFiRegistryCommand<VoidResult> {
    public UpdateUser() {
        super("update-user", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates an existing user.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.USER_ID.createOption());
        this.addOption(CommandOption.USER_NAME.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        TenantsClient tenantsClient = client.getTenantsClient();
        String userId = this.getRequiredArg(properties, CommandOption.USER_ID);
        User existingUser = tenantsClient.getUser(userId);
        String userName = this.getArg(properties, CommandOption.USER_NAME);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            existingUser.setIdentity(userName);
        }
        tenantsClient.updateUser(existingUser);
        return VoidResult.getInstance();
    }
}

