/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.NonNull;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.util.Assert;

abstract class AbstractExpressionAttributeRegistry<T extends ExpressionAttribute> {
    private final Map<MethodClassKey, T> cachedAttributes = new ConcurrentHashMap<MethodClassKey, T>();
    private MethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();

    AbstractExpressionAttributeRegistry() {
    }

    final T getAttribute(MethodInvocation mi) {
        Method method = mi.getMethod();
        Object target = mi.getThis();
        Class<?> targetClass = target != null ? target.getClass() : null;
        return this.getAttribute(method, targetClass);
    }

    final T getAttribute(Method method, Class<?> targetClass) {
        MethodClassKey cacheKey = new MethodClassKey(method, targetClass);
        return (T)this.cachedAttributes.computeIfAbsent(cacheKey, k -> this.resolveAttribute(method, targetClass));
    }

    MethodSecurityExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        Assert.notNull((Object)expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
    }

    @Deprecated
    void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        AnnotationTemplateExpressionDefaults adapter = new AnnotationTemplateExpressionDefaults();
        adapter.setIgnoreUnknown(defaults.isIgnoreUnknown());
        this.setTemplateDefaults(adapter);
    }

    abstract void setTemplateDefaults(AnnotationTemplateExpressionDefaults var1);

    @NonNull
    abstract T resolveAttribute(Method var1, Class<?> var2);

    Class<?> targetClass(Method method, Class<?> targetClass) {
        return targetClass != null ? targetClass : method.getDeclaringClass();
    }
}

