/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class HttpTracing {
    private static final Logger LOG = Logger.getLogger(HttpTracing.class.getName());

    private HttpTracing() {
    }

    private static TraceContext extract(Tracer tracer, HttpRequest request) {
        Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"Request", (Object)request);
        return tracer.getPropagator().extractContext(tracer.getCurrentContext(), request, (req, key) -> req.getHeader(key));
    }

    public static Span newSpanAsChildOf(Tracer tracer, HttpRequest request, String name) {
        Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"Request", (Object)request);
        Require.nonNull((String)"Name", (Object)name);
        TraceContext parent = HttpTracing.extract(tracer, request);
        return parent.createSpan(name);
    }

    public static void inject(Tracer tracer, TraceContext context, HttpRequest request) {
        if (context == null) {
            return;
        }
        Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"Request", (Object)request);
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        LOG.fine(String.format("Injecting %s into %s at %s:%d", request, context, caller.getClassName(), caller.getLineNumber()));
        tracer.getPropagator().inject(context, request, (req, key, value) -> req.setHeader(key, value));
    }
}

