/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec.w3c;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.codec.AbstractHttpCommandCodec;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class W3CHttpCommandCodec
extends AbstractHttpCommandCodec {
    private static final ConcurrentHashMap<String, String> ATOM_SCRIPTS = new ConcurrentHashMap();
    private static final Pattern CSS_ESCAPE = Pattern.compile("([\\s'\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-\\/\\[\\]\\(\\)])");

    public W3CHttpCommandCodec() {
        String sessionId = "/session/:sessionId";
        this.alias("getElementAttribute", "executeScript");
        this.alias("getElementLocation", "getElementRect");
        this.alias("getElementLocationOnceScrolledIntoView", "executeScript");
        this.alias("getElementSize", "getElementRect");
        this.alias("isElementDisplayed", "executeScript");
        this.alias("submitElement", "executeScript");
        this.defineCommand("executeScript", W3CHttpCommandCodec.post(sessionId + "/execute/sync"));
        this.defineCommand("executeAsyncScript", W3CHttpCommandCodec.post(sessionId + "/execute/async"));
        this.alias("getPageSource", "executeScript");
        this.alias("clearLocalStorage", "executeScript");
        this.alias("getLocalStorageKeys", "executeScript");
        this.alias("setLocalStorageItem", "executeScript");
        this.alias("removeLocalStorageItem", "executeScript");
        this.alias("getLocalStorageItem", "executeScript");
        this.alias("getLocalStorageSize", "executeScript");
        this.alias("clearSessionStorage", "executeScript");
        this.alias("getSessionStorageKey", "executeScript");
        this.alias("setSessionStorageItem", "executeScript");
        this.alias("removeSessionStorageItem", "executeScript");
        this.alias("getSessionStorageItem", "executeScript");
        this.alias("getSessionStorageSize", "executeScript");
        String window = sessionId + "/window";
        this.defineCommand("maximizeCurrentWindow", W3CHttpCommandCodec.post(window + "/maximize"));
        this.defineCommand("minimizeCurrentWindow", W3CHttpCommandCodec.post(window + "/minimize"));
        this.defineCommand("getCurrentWindowSize", W3CHttpCommandCodec.get(window + "/rect"));
        this.defineCommand("setCurrentWindowSize", W3CHttpCommandCodec.post(window + "/rect"));
        this.alias("getWindowPosition", "getCurrentWindowSize");
        this.alias("setWindowPosition", "setCurrentWindowSize");
        this.defineCommand("getCurrentWindowHandle", W3CHttpCommandCodec.get(window));
        this.defineCommand("getWindowHandles", W3CHttpCommandCodec.get(window + "/handles"));
        String alert = sessionId + "/alert";
        this.defineCommand("acceptAlert", W3CHttpCommandCodec.post(alert + "/accept"));
        this.defineCommand("dismissAlert", W3CHttpCommandCodec.post(alert + "/dismiss"));
        this.defineCommand("getAlertText", W3CHttpCommandCodec.get(alert + "/text"));
        this.defineCommand("setAlertValue", W3CHttpCommandCodec.post(alert + "/text"));
        this.defineCommand("printPage", W3CHttpCommandCodec.post(sessionId + "/print"));
        this.defineCommand("uploadFile", W3CHttpCommandCodec.post(sessionId + "/se/file"));
        this.defineCommand("getActiveElement", W3CHttpCommandCodec.get(sessionId + "/element/active"));
        this.defineCommand("actions", W3CHttpCommandCodec.post(sessionId + "/actions"));
        this.defineCommand("clearActionState", W3CHttpCommandCodec.delete(sessionId + "/actions"));
        String elementId = sessionId + "/element/:id";
        this.defineCommand("getElementDomProperty", W3CHttpCommandCodec.get(elementId + "/property/:name"));
        this.defineCommand("getElementDomAttribute", W3CHttpCommandCodec.get(elementId + "/attribute/:name"));
        this.defineCommand("getElementAriaRole", W3CHttpCommandCodec.get(elementId + "/computedrole"));
        this.defineCommand("getElementAccessibleName", W3CHttpCommandCodec.get(elementId + "/computedlabel"));
        this.defineCommand("getElementShadowRoot", W3CHttpCommandCodec.get(elementId + "/shadow"));
        this.defineCommand("findElementFromShadowRoot", W3CHttpCommandCodec.post(sessionId + "/shadow/:shadowId/element"));
        this.defineCommand("findElementsFromShadowRoot", W3CHttpCommandCodec.post(sessionId + "/shadow/:shadowId/elements"));
        this.defineCommand("getLog", W3CHttpCommandCodec.post(sessionId + "/se/log"));
        this.defineCommand("getAvailableLogTypes", W3CHttpCommandCodec.get(sessionId + "/se/log/types"));
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "findChildElement": 
            case "findChildElements": 
            case "findElement": 
            case "findElements": {
                String using = (String)parameters.get("using");
                Object value = parameters.get("value");
                if (value instanceof String) {
                    String stringValue = (String)value;
                    switch (using) {
                        case "class name": {
                            if (stringValue.matches(".*\\s.*")) {
                                throw new InvalidSelectorException("Compound class names not permitted");
                            }
                            return this.amendLocatorToCssSelector(parameters, "." + this.cssEscape(stringValue));
                        }
                        case "id": {
                            return this.amendLocatorToCssSelector(parameters, "#" + this.cssEscape(stringValue));
                        }
                        case "name": {
                            return this.amendLocatorToCssSelector(parameters, "*[name='" + stringValue + "']");
                        }
                    }
                }
                return parameters;
            }
            case "getElementAttribute": {
                return this.executeAtom("getAttribute.js", this.asElement(parameters.get("id")), parameters.get("name"));
            }
            case "getElementLocationOnceScrolledIntoView": {
                return this.toScript("var e = arguments[0]; e.scrollIntoView({behavior: 'instant', block: 'end', inline: 'nearest'}); var rect = e.getBoundingClientRect(); return {'x': rect.left, 'y': rect.top};", this.asElement(parameters.get("id")));
            }
            case "getPageSource": {
                return this.toScript("var source = document.documentElement.outerHTML; \nif (!source) { source = new XMLSerializer().serializeToString(document); }\nreturn source;", new Object[0]);
            }
            case "clearLocalStorage": {
                return this.toScript("localStorage.clear()", new Object[0]);
            }
            case "getLocalStorageKeys": {
                return this.toScript("return Object.keys(localStorage)", new Object[0]);
            }
            case "setLocalStorageItem": {
                return this.toScript("localStorage.setItem(arguments[0], arguments[1])", parameters.get("key"), parameters.get("value"));
            }
            case "removeLocalStorageItem": {
                return this.toScript("var item = localStorage.getItem(arguments[0]); localStorage.removeItem(arguments[0]); return item", parameters.get("key"));
            }
            case "getLocalStorageItem": {
                return this.toScript("return localStorage.getItem(arguments[0])", parameters.get("key"));
            }
            case "getLocalStorageSize": {
                return this.toScript("return localStorage.length", new Object[0]);
            }
            case "clearSessionStorage": {
                return this.toScript("sessionStorage.clear()", new Object[0]);
            }
            case "getSessionStorageKey": {
                return this.toScript("return Object.keys(sessionStorage)", new Object[0]);
            }
            case "setSessionStorageItem": {
                return this.toScript("sessionStorage.setItem(arguments[0], arguments[1])", parameters.get("key"), parameters.get("value"));
            }
            case "removeSessionStorageItem": {
                return this.toScript("var item = sessionStorage.getItem(arguments[0]); sessionStorage.removeItem(arguments[0]); return item", parameters.get("key"));
            }
            case "getSessionStorageItem": {
                return this.toScript("return sessionStorage.getItem(arguments[0])", parameters.get("key"));
            }
            case "getSessionStorageSize": {
                return this.toScript("return sessionStorage.length", new Object[0]);
            }
            case "isElementDisplayed": {
                return this.executeAtom("isDisplayed.js", this.asElement(parameters.get("id")));
            }
            case "sendKeysToElement": {
                Object rawValue = parameters.get("value");
                Stream<Object> source = rawValue instanceof Collection ? ((Collection)rawValue).stream() : Stream.of((CharSequence[])rawValue);
                String text = source.collect(Collectors.joining());
                LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>();
                parameters.forEach((key, val) -> {
                    if ("text".equals(key) || "value".equals(key)) {
                        return;
                    }
                    merged.put((String)key, val);
                });
                merged.put("text", text);
                merged.put("value", this.stringToUtf8Array(text));
                return Map.copyOf(merged);
            }
            case "setAlertValue": {
                return Map.of("text", parameters.get("text"), "value", this.stringToUtf8Array((String)parameters.get("text")));
            }
            case "setTimeout": {
                String timeoutType = (String)parameters.get("type");
                Number duration = (Number)parameters.get("ms");
                if (timeoutType == null) {
                    return parameters;
                }
                LinkedHashMap<String, Number> merged = new LinkedHashMap<String, Number>();
                parameters.forEach((key, val) -> {
                    if (timeoutType.equals(key)) {
                        return;
                    }
                    merged.put((String)key, (Number)val);
                });
                merged.put(timeoutType, duration);
                return Map.copyOf(merged);
            }
            case "submitElement": {
                return this.toScript("/* submitForm */var form = arguments[0];\nwhile (form.nodeName != \"FORM\" && form.parentNode) {\n  form = form.parentNode;\n}\nif (!form) { throw Error('Unable to find containing form element'); }\nif (!form.ownerDocument) { throw Error('Unable to find owning document'); }\nvar e = form.ownerDocument.createEvent('Event');\ne.initEvent('submit', true, true);\nif (form.dispatchEvent(e)) { HTMLFormElement.prototype.submit.call(form) }\n", this.asElement(parameters.get("id")));
            }
        }
        return parameters;
    }

    private List<String> stringToUtf8Array(String toConvert) {
        int next;
        ArrayList<String> toReturn = new ArrayList<String>();
        for (int offset = 0; offset < toConvert.length(); offset += Character.charCount(next)) {
            next = toConvert.codePointAt(offset);
            toReturn.add(new StringBuilder().appendCodePoint(next).toString());
        }
        return toReturn;
    }

    private Map<String, ?> executeAtom(String atomFileName, Object ... args) {
        try {
            String script = ATOM_SCRIPTS.computeIfAbsent(atomFileName, fileName -> {
                String rawFunction;
                String scriptName = "/org/openqa/selenium/remote/" + atomFileName;
                try (InputStream stream = this.getClass().getResourceAsStream(scriptName);){
                    rawFunction = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                String atomName = fileName.replace(".js", "");
                return String.format("/* %s */return (%s).apply(null, arguments);", atomName, rawFunction);
            });
            return this.toScript(script, args);
        }
        catch (UncheckedIOException e) {
            throw new WebDriverException((Throwable)e.getCause());
        }
        catch (NullPointerException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Map<String, ?> toScript(String script, Object ... args) {
        List convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return Map.of("script", script, "args", convertedArgs);
    }

    private Map<String, String> asElement(Object id) {
        return Map.of("element-6066-11e4-a52e-4f735466cecf", (String)id);
    }

    private String cssEscape(String using) {
        if (!((String)(using = CSS_ESCAPE.matcher((CharSequence)using).replaceAll("\\\\$1"))).isEmpty() && Character.isDigit(((String)using).charAt(0))) {
            using = "\\" + (30 + Integer.parseInt(((String)using).substring(0, 1))) + " " + ((String)using).substring(1);
        }
        return using;
    }

    private Map<String, ?> amendLocatorToCssSelector(Map<String, ?> parameters, String value) {
        HashMap amended = new HashMap(parameters);
        amended.put("using", "css selector");
        amended.put("value", value);
        return amended;
    }
}

