/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.AddHasCasting;
import org.openqa.selenium.chrome.AddHasCdp;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriver
extends ChromiumDriver {
    public ChromeDriver() {
        this(ChromeDriverService.createDefaultService(), new ChromeOptions());
    }

    public ChromeDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    public ChromeDriver(ChromeOptions options) {
        this(ChromeDriverService.createServiceWithConfig(options), options);
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options) {
        super((CommandExecutor)new ChromeDriverCommandExecutor(service), (Capabilities)Require.nonNull((String)"Driver options", (Object)((Object)options)), "goog:chromeOptions");
        this.casting = new AddHasCasting().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.cdp = new AddHasCdp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new ChromeOptions(), new Capabilities[0]);
    }

    private static class ChromeDriverCommandExecutor
    extends ChromiumDriverCommandExecutor {
        public ChromeDriverCommandExecutor(DriverService service) {
            super(service, ChromeDriverCommandExecutor.getExtraCommands());
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasCasting().getAdditionalCommands()).putAll(new AddHasCdp().getAdditionalCommands()).build();
        }
    }
}

