/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.Bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.LittleEndianBitConverter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.UuidUtils;

public class BitWriter {
    private final BitSet bitSet;
    private int bitOffset;

    public BitWriter(int bufferSize) {
        this.bitSet = new BitSet(bufferSize);
        this.bitOffset = 0;
    }

    public byte[] getBytes() throws IOException {
        if (this.bitOffset % 8 != 0) {
            throw new IOException("BitWriter:Bytes, Cannot get the current bytes because the last byte is not written completely.");
        }
        int retByteLength = this.bitOffset / 8;
        return Arrays.copyOfRange(this.bitSet.toByteArray(), 0, retByteLength);
    }

    public List<Byte> getByteList() throws IOException {
        byte[] bytes = this.getBytes();
        ArrayList<Byte> byteList = new ArrayList<Byte>(bytes.length);
        for (byte aByte : bytes) {
            byteList.add(aByte);
        }
        return byteList;
    }

    public void appendUInt64(long value, int length) {
        byte[] convertedBytes = LittleEndianBitConverter.getBytes(value);
        this.setBytes(convertedBytes, length);
    }

    public void appendUInit32(int value, int length) {
        byte[] convertedBytes = LittleEndianBitConverter.getBytes(value);
        this.setBytes(convertedBytes, length);
    }

    public void appendInit32(int value, int length) {
        byte[] convertedBytes = LittleEndianBitConverter.getBytes(value);
        this.setBytes(convertedBytes, length);
    }

    public void appendGUID(UUID value) {
        this.setBytes(UuidUtils.asBytes(value), 128);
    }

    private void setBytes(byte[] needWrittenBytes, int length) {
        for (int i = 0; i < length; ++i) {
            if (Bit.isBitSet(needWrittenBytes, i)) {
                this.bitSet.set(this.bitOffset++);
                continue;
            }
            this.bitSet.clear(this.bitOffset++);
        }
    }
}

