/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.archive.extract.ExtractorOutput;
import org.archive.format.json.JSONView;
import org.archive.resource.Resource;
import org.archive.util.StreamCopy;

public class CDXExtractorOutput
implements ExtractorOutput {
    private static String URL_SPEC = "Envelope.ARC-Header-Metadata.Target-URI|Envelope.WARC-Header-Metadata.Target-URI";
    private static String DATE_SPEC = "Envelope.ARC-Header-Metadata.Date";
    private static String MIME_SPEC = "Envelope.ARC-Header-Metadata.Content-Type";
    private static String HTTP_CODE_SPEC = "Envelope.Payload-Metadata.HTTP-Response-Metadata.Response-Message.Status";
    private static String SHA1_SPEC = "Envelope.Payload-Metadata.HTTP-Response-Metadata.Entity-Digest";
    private static String REDIR_SPEC = "Envelope.Payload-Metadata.HTTP-Response-Metadata.Headers.Content-Location";
    private static String OFFSET_SPEC = "Container.Offset";
    private static String FILENAME_SPEC = "Container.Filename";
    private static String[] SPECS = new String[]{URL_SPEC, DATE_SPEC, URL_SPEC, MIME_SPEC, HTTP_CODE_SPEC, SHA1_SPEC, REDIR_SPEC, OFFSET_SPEC, FILENAME_SPEC};
    private static char EMPTY = (char)45;
    private static char DELIM = (char)32;
    JSONView view = new JSONView(SPECS);
    private PrintStream out;

    public CDXExtractorOutput(PrintStream out) {
        this.out = out;
    }

    @Override
    public void output(Resource resource) throws IOException {
        StreamCopy.readToEOF(resource.getInputStream());
        List<List<String>> res = this.view.apply(resource.getMetaData().getTopMetaData());
        StringBuilder sb = new StringBuilder();
        for (List<String> actual : res) {
            sb.setLength(0);
            for (int i = 0; i < actual.size(); ++i) {
                String f;
                if (i > 0) {
                    sb.append(DELIM);
                }
                if ((f = actual.get(i)) == null || f.length() == 0) {
                    sb.append(EMPTY);
                    continue;
                }
                if (i == 5) {
                    sb.append(f.substring(5));
                    continue;
                }
                sb.append(f);
            }
            this.out.println(sb.toString());
        }
    }
}

