/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.archive.url.SURTTokenizer;
import org.archive.url.URIException;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.PeekableIterator;

public class SURT {
    private static final Logger LOG = Logger.getLogger(SURT.class.getCanonicalName());

    public static String toSURT(String input) {
        if (input.startsWith("(")) {
            return input;
        }
        try {
            String tmp = SURTTokenizer.prefixKey(input);
            if (tmp.contains("/")) {
                return tmp;
            }
            return tmp + ",";
        }
        catch (URIException e) {
            LOG.warning("URI Exception for(" + input + "):" + e.getLocalizedMessage());
            return input;
        }
    }

    public static void main(String[] args) {
        InputStreamReader isr = new InputStreamReader(System.in, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        PeekableIterator<String> i = AbstractPeekableIterator.wrapReader(br);
        while (i.hasNext()) {
            String line = (String)i.next();
            System.out.println(SURT.toSURT(line));
        }
    }
}

