/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.search.lookup.SearchLookup;

public class TokenCountFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    public static ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private final Integer nullValue;

    private static TokenCountFieldMapper toType(FieldMapper in) {
        return (TokenCountFieldMapper)in;
    }

    protected TokenCountFieldMapper(String simpleName, MappedFieldType defaultFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, defaultFieldType, multiFields, copyTo);
        this.analyzer = (NamedAnalyzer)builder.analyzer.getValue();
        this.enablePositionIncrements = (Boolean)builder.enablePositionIncrements.getValue();
        this.nullValue = (Integer)builder.nullValue.getValue();
        this.index = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.store = (Boolean)builder.store.getValue();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions((Analyzer)this.analyzer, this.name(), value, this.enablePositionIncrements);
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), (Number)tokenCount, this.index, this.hasDocValues, this.store));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    static class TokenCountFieldType
    extends NumberFieldMapper.NumberFieldType {
        TokenCountFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Number nullValue, Map<String, String> meta) {
            super(name, NumberFieldMapper.NumberType.INTEGER, isSearchable, isStored, hasDocValues, false, nullValue, meta);
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (!this.hasDocValues()) {
                return lookup -> org.opensearch.common.collect.List.of();
            }
            return new DocValueFetcher(this.docValueFormat(format, null), searchLookup.doc().getForField((MappedFieldType)this));
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> TokenCountFieldMapper.access$600(TokenCountFieldMapper.toType(m)), (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> TokenCountFieldMapper.access$500(TokenCountFieldMapper.toType(m)), (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> TokenCountFieldMapper.access$400(TokenCountFieldMapper.toType(m)), (boolean)false);
        private final ParametrizedFieldMapper.Parameter<NamedAnalyzer> analyzer = ParametrizedFieldMapper.Parameter.analyzerParam((String)"analyzer", (boolean)true, m -> TokenCountFieldMapper.access$300(TokenCountFieldMapper.toType(m)), () -> null);
        private final ParametrizedFieldMapper.Parameter<Integer> nullValue = new ParametrizedFieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue((Object)o)), m -> TokenCountFieldMapper.access$200(TokenCountFieldMapper.toType(m))).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Boolean> enablePositionIncrements = ParametrizedFieldMapper.Parameter.boolParam((String)"enable_position_increments", (boolean)false, m -> TokenCountFieldMapper.access$100(TokenCountFieldMapper.toType(m)), (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.hasDocValues, this.store, this.analyzer, this.nullValue, this.enablePositionIncrements, this.meta);
        }

        public TokenCountFieldMapper build(Mapper.BuilderContext context) {
            if (this.analyzer.getValue() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + this.name + "] but wasn't.");
            }
            TokenCountFieldType ft = new TokenCountFieldType(this.buildFullName(context), (Boolean)this.index.getValue(), (Boolean)this.store.getValue(), (Boolean)this.hasDocValues.getValue(), (Number)this.nullValue.getValue(), (Map)this.meta.getValue());
            return new TokenCountFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this);
        }
    }
}

