/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.desktop.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class CalendarBean {
    private Date date = new Date();
    private String notes = "";

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = date;
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getDateKey(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        return formatter.format(date);
    }

    public String save() {
        if (this.date != null) {
            PortletRequest request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            PortletPreferences prefs = request.getPreferences();
            try {
                prefs.setValue(this.getDateKey(this.date), this.notes);
                prefs.store();
            }
            catch (Exception e) {
                System.err.println("error storing prefs " + e);
            }
        }
        return "returnFromNotes";
    }

    public String selectDate() {
        if (this.date == null) {
            return "editNotes";
        }
        String selectedDate = this.getDateKey(this.date);
        PortletRequest request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        this.notes = request.getPreferences().getValue(selectedDate, "");
        return "editNotes";
    }
}

