/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.springmvc;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.applications.springmvc.DOMTree;
import org.apache.portals.applications.springmvc.DOMTreeService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class DOMTreePrefsController
extends SimpleFormController
implements InitializingBean {
    private DOMTreeService domTreeService;

    public void afterPropertiesSet() throws Exception {
        if (this.domTreeService == null) {
            throw new IllegalArgumentException("DOMTreeService is required");
        }
    }

    public void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        String save = request.getParameter("save");
        if (save != null) {
            this.domTreeService.saveDOMTree(request.getParameter("name"), request.getParameter("path"), (PortletRequest)request);
        }
        response.setRenderParameter("action", "list");
    }

    protected Object formBackingObject(PortletRequest request) throws Exception {
        String name = request.getParameter("domTree");
        if (name == null) {
            return new DOMTree();
        }
        return this.domTreeService.getDOMTree(name, request);
    }

    protected void initBinder(PortletRequest request, PortletRequestDataBinder binder) throws Exception {
    }

    protected ModelAndView renderInvalidSubmit(RenderRequest request, RenderResponse response) throws Exception {
        return null;
    }

    protected void handleInvalidSubmit(ActionRequest request, ActionResponse response) throws Exception {
        response.setRenderParameter("action", "view");
    }

    public void setDomTreeService(DOMTreeService domTreeService) {
        this.domTreeService = domTreeService;
    }
}

