/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.springmvc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.applications.springmvc.DOMTree;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ApplicationObjectSupport;
import org.w3c.dom.Document;

public class DOMTreeService
extends ApplicationObjectSupport {
    private static final String DOM_TREE_NO_PATH = "domtree_no_path";
    private static final String DOM_TREE_NO_PARSE = "domtree_no_parse";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$applications$springmvc$DOMTreeService == null ? (class$org$apache$portals$applications$springmvc$DOMTreeService = DOMTreeService.class$((String)"org.apache.portals.applications.springmvc.DOMTreeService")) : class$org$apache$portals$applications$springmvc$DOMTreeService));
    protected DocumentBuilderFactory domFactory = null;
    static /* synthetic */ Class class$org$apache$portals$applications$springmvc$DOMTreeService;

    public void initApplicationContext() throws BeansException {
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setValidating(false);
    }

    public DOMTree getDOMTree(String name, PortletRequest request) {
        if (name == null) {
            name = "";
        }
        PortletPreferences prefs = request.getPreferences();
        String path = prefs.getValue(name, "");
        return new DOMTree(name, path);
    }

    public void saveDOMTree(String name, String path, PortletRequest request) {
        DOMTree dt = new DOMTree(name, path);
        this.saveDOMTree(dt, request);
    }

    public void saveDOMTree(DOMTree dt, PortletRequest request) {
        if (dt == null) {
            return;
        }
        PortletPreferences prefs = request.getPreferences();
        try {
            prefs.setValue(dt.getName(), dt.getPath());
            prefs.store();
        }
        catch (ReadOnlyException e) {
        }
        catch (IOException e) {
        }
        catch (ValidatorException e) {
            // empty catch block
        }
    }

    public void deleteDOMTree(String name, PortletRequest request) {
        if (name == null) {
            name = "";
        }
        PortletPreferences prefs = request.getPreferences();
        try {
            prefs.reset(name);
            prefs.store();
        }
        catch (ReadOnlyException e) {
        }
        catch (IOException e) {
        }
        catch (ValidatorException e) {
            // empty catch block
        }
    }

    public SortedSet getAllDOMTrees(PortletRequest request) {
        return this.getAllDOMTrees(request, null);
    }

    public SortedSet getAllDOMTrees(PortletRequest request, List addTo) {
        if (addTo == null) {
            addTo = new ArrayList<DOMTree>();
        }
        PortletPreferences prefs = request.getPreferences();
        Enumeration e = prefs.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String path = prefs.getValue(name, "");
            addTo.add(new DOMTree(name, path));
        }
        return new TreeSet(addTo);
    }

    public SortedSet parseAllDOMTrees(PortletRequest request, PortletContext context, List addTo) {
        SortedSet domTreeSet = this.getAllDOMTrees(request, addTo);
        Iterator domTreeSetIter = domTreeSet.iterator();
        while (domTreeSetIter.hasNext()) {
            DOMTree dt = (DOMTree)domTreeSetIter.next();
            if (dt.getPath() == null || dt.getPath().length() == 0) {
                dt.setMessage(DOM_TREE_NO_PATH);
                continue;
            }
            InputStream is = context.getResourceAsStream(dt.getPath());
            Document doc = this.parseXml(is);
            dt.setParsedDocument(doc);
            if (doc != null) continue;
            dt.setMessage(DOM_TREE_NO_PARSE);
        }
        return domTreeSet;
    }

    protected Document parseXml(InputStream is) {
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = this.domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Cannot create DocumentBuilder due to " + e.getClass().getName() + " " + e.getMessage()));
        }
        if (docBuilder != null) {
            try {
                doc = docBuilder.parse(is);
            }
            catch (Exception e) {
                log.error((Object)("Cannot parse due to " + e.getClass().getName() + " " + e.getMessage()));
            }
        }
        return doc;
    }
}

