/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AclClientRPCHook
implements RPCHook {
    private final SessionCredentials sessionCredentials;

    public AclClientRPCHook(SessionCredentials sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
    }

    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
        request.addExtField("AccessKey", this.sessionCredentials.getAccessKey());
        if (this.sessionCredentials.getSecurityToken() != null) {
            request.addExtField("SecurityToken", this.sessionCredentials.getSecurityToken());
        }
        byte[] total = AclUtils.combineRequestContent(request, this.parseRequestContent(request));
        String signature = AclUtils.calSignature(total, this.sessionCredentials.getSecretKey());
        request.addExtField("Signature", signature);
    }

    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
    }

    protected SortedMap<String, String> parseRequestContent(RemotingCommand request) {
        request.makeCustomHeaderToNet();
        HashMap extFields = request.getExtFields();
        return new TreeMap<String, String>(extFields);
    }

    public SessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }
}

