/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.protocol.http2proxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.remoting.protocol.ProtocolHandler;
import org.apache.rocketmq.proxy.remoting.protocol.http2proxy.HAProxyMessageForwarder;
import org.apache.rocketmq.proxy.remoting.protocol.http2proxy.Http2ProxyBackendHandler;
import org.apache.rocketmq.proxy.remoting.protocol.http2proxy.Http2ProxyFrontendHandler;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;

public class Http2ProtocolProxyHandler
implements ProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final int PRI_INT = 1347569952;
    private final SslContext sslContext;

    public Http2ProtocolProxyHandler() {
        try {
            TlsMode tlsMode = TlsSystemConfig.tlsMode;
            this.sslContext = TlsMode.DISABLED.equals((Object)tlsMode) ? null : SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"})).build();
        }
        catch (SSLException e) {
            log.error("Failed to create SSLContext for Http2ProtocolProxyHandler", (Throwable)e);
            throw new RuntimeException("Failed to create SSLContext for Http2ProtocolProxyHandler", e);
        }
    }

    @Override
    public boolean match(ByteBuf in) {
        if (!ConfigurationManager.getProxyConfig().isEnableRemotingLocalProxyGrpc()) {
            return false;
        }
        return in.getInt(in.readerIndex()) == 1347569952;
    }

    @Override
    public void config(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelFuture f;
        final Channel inboundChannel = ctx.channel();
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(null, "Http2ProxyBackendHandler", (ChannelHandler)new Http2ProxyBackendHandler(inboundChannel));
            }
        })).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getLocalProxyConnectTimeoutMs());
        try {
            f = b.connect(LOCAL_HOST, config.getGrpcServerPort().intValue()).sync();
        }
        catch (Exception e) {
            log.error("connect http2 server failed. port:{}", (Object)config.getGrpcServerPort(), (Object)e);
            inboundChannel.close();
            return;
        }
        Channel outboundChannel = f.channel();
        this.configPipeline(inboundChannel, outboundChannel);
        SslHandler sslHandler = null;
        if (this.sslContext != null) {
            sslHandler = this.sslContext.newHandler(outboundChannel.alloc(), LOCAL_HOST, config.getGrpcServerPort().intValue());
        }
        ctx.pipeline().addLast(new ChannelHandler[]{new Http2ProxyFrontendHandler(outboundChannel, sslHandler)});
    }

    protected void configPipeline(Channel inboundChannel, Channel outboundChannel) {
        inboundChannel.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageForwarder(outboundChannel)});
        outboundChannel.pipeline().addFirst(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
    }
}

