/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.Map;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumer;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumerBuilder;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.LitePushConsumerImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.common.collect.ImmutableMap;
import org.apache.rocketmq.shaded.commons.lang3.StringUtils;

public class LitePushConsumerBuilderImpl
implements LitePushConsumerBuilder {
    protected String bindTopic = null;
    protected ClientConfiguration clientConfiguration = null;
    protected String consumerGroup = null;
    protected Map<String, FilterExpression> subscriptionExpressions = null;
    protected MessageListener messageListener = null;
    protected int maxCacheMessageCount = 1024;
    protected int maxCacheMessageSizeInBytes = 0x4000000;
    protected int consumptionThreadCount = 20;

    @Override
    public LitePushConsumerBuilder bindTopic(String bindTopic) {
        Preconditions.checkArgument(StringUtils.isNotBlank(bindTopic), "bindTopic should not be blank");
        this.bindTopic = bindTopic;
        return this;
    }

    @Override
    public LitePushConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        return this;
    }

    @Override
    public LitePushConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull(consumerGroup, "consumerGroup should not be null");
        Preconditions.checkArgument(ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), "consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public LitePushConsumerBuilder setMessageListener(MessageListener messageListener) {
        this.messageListener = Preconditions.checkNotNull(messageListener, "messageListener should not be null");
        return this;
    }

    @Override
    public LitePushConsumerBuilder setMaxCacheMessageCount(int maxCachedMessageCount) {
        Preconditions.checkArgument(maxCachedMessageCount > 0, "maxCachedMessageCount should be positive");
        this.maxCacheMessageCount = maxCachedMessageCount;
        return this;
    }

    @Override
    public LitePushConsumerBuilder setMaxCacheMessageSizeInBytes(int maxCacheMessageSizeInBytes) {
        Preconditions.checkArgument(maxCacheMessageSizeInBytes > 0, "maxCacheMessageSizeInBytes should be positive");
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
        return this;
    }

    @Override
    public LitePushConsumerBuilder setConsumptionThreadCount(int consumptionThreadCount) {
        Preconditions.checkArgument(consumptionThreadCount > 0, "consumptionThreadCount should be positive");
        this.consumptionThreadCount = consumptionThreadCount;
        return this;
    }

    @Override
    public LitePushConsumer build() throws ClientException {
        Preconditions.checkNotNull(this.clientConfiguration, "clientConfiguration has not been set yet");
        Preconditions.checkNotNull(this.consumerGroup, "consumerGroup has not been set yet");
        Preconditions.checkNotNull(this.messageListener, "messageListener has not been set yet");
        Preconditions.checkNotNull(this.bindTopic, "bindTopic has not been set yet");
        this.subscriptionExpressions = ImmutableMap.of(this.bindTopic, FilterExpression.SUB_ALL);
        LitePushConsumerImpl litePushConsumer = new LitePushConsumerImpl(this);
        litePushConsumer.startAsync().awaitRunning();
        return litePushConsumer;
    }
}

