/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import io.vertx.core.Context;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.governance.GovernanceConfiguration;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.core.governance.RetryContext;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.handler.ext.FailurePredictor;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerUtils.class);
    private static final Object LOCK = new Object();
    private static volatile ScheduledExecutorService reactiveRetryPool;
    private static RetryHandler retryHandler;
    private static final boolean ENABLE_EVENT_LOOP_BLOCKING_CALL_CHECK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScheduledExecutorService getOrCreateRetryPool() {
        if (reactiveRetryPool == null) {
            Object object = LOCK;
            synchronized (object) {
                if (reactiveRetryPool == null) {
                    reactiveRetryPool = Executors.newScheduledThreadPool(2, new ThreadFactory(){
                        private final AtomicInteger count = new AtomicInteger(0);

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread thread = new Thread(r, "reactive-retry-pool-thread-" + this.count.getAndIncrement());
                            thread.setDaemon(true);
                            return thread;
                        }
                    });
                }
            }
        }
        return reactiveRetryPool;
    }

    public static <T> T syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        return (T)InvokerUtils.syncInvoke(invocation);
    }

    public static void reactiveInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        InvokerUtils.reactiveInvoke(invocation, asyncResp);
    }

    public static <T> T syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType);
    }

    public static void reactiveInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        InvokerUtils.reactiveInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType, asyncResp);
    }

    private static Invocation createInvocation(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().createMicroserviceReferenceConfig(microserviceName, microserviceVersion);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(schemaId);
        OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(transport, operationMeta);
        InvocationRuntimeType invocationRuntimeType = operationMeta.buildBaseConsumerRuntimeType();
        invocationRuntimeType.setSuccessResponseType(responseType);
        return InvocationFactory.forConsumer(referenceConfig, operationMeta, invocationRuntimeType, swaggerArguments);
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments);
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, null);
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSucceed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static boolean isInEventLoop() {
        return Context.isOnEventLoopThread();
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest(invocation);
        return InvokerUtils.decorateSyncRetry(invocation, request);
    }

    private static Response innerSyncInvokeImpl(Invocation invocation) throws Throwable {
        if (ENABLE_EVENT_LOOP_BLOCKING_CALL_CHECK && InvokerUtils.isInEventLoop()) {
            throw new IllegalStateException("Can not execute sync logic in event loop. ");
        }
        invocation.onStart(null, System.nanoTime());
        InvokerUtils.updateRetryStatus(invocation);
        SyncResponseExecutor respExecutor = new SyncResponseExecutor();
        invocation.setResponseExecutor(respExecutor);
        invocation.onStartHandlersRequest();
        invocation.next(respExecutor::setResponse);
        Response response = respExecutor.waitResponse(invocation);
        invocation.getInvocationStageTrace().finishHandlersResponse();
        invocation.onFinish(response);
        if (response.getStatusCode() == 101) {
            response.setStatus((Response.StatusType)Response.Status.OK);
        }
        if (response.isFailed()) {
            if (!(response.getResult() instanceof InvocationException)) {
                throw (Throwable)response.getResult();
            }
            if (((InvocationException)response.getResult()).getStatusCode() == 490) {
                throw (Throwable)response.getResult();
            }
        }
        return response;
    }

    private static void updateRetryStatus(Invocation invocation) {
        if (invocation.isFinished()) {
            invocation.reset();
            if (invocation.getLocalContext("x-context-retry-loadbalance") != null && ((Boolean)invocation.getLocalContext("x-context-retry-loadbalance")).booleanValue()) {
                invocation.setEndpoint(null);
            }
            RetryContext retryContext = (RetryContext)invocation.getLocalContext("x-context-retry");
            retryContext.incrementRetry();
            return;
        }
        invocation.addLocalContext("x-context-retry", new RetryContext(GovernanceConfiguration.getRetrySameServer(invocation.getMicroserviceName())));
    }

    private static Response decorateSyncRetry(Invocation invocation, GovernanceRequestExtractor request) {
        try {
            Retry retry;
            if (retryHandler == null) {
                retryHandler = (RetryHandler)BeanUtils.getBean(RetryHandler.class);
            }
            if ((retry = (Retry)retryHandler.getActuator(request)) != null) {
                CheckedFunction0 supplier = Retry.decorateCheckedSupplier((Retry)retry, (CheckedFunction0 & Serializable)() -> InvokerUtils.innerSyncInvokeImpl(invocation));
                return (Response)Try.of((CheckedFunction0)supplier).get();
            }
            if (InvokerUtils.isCompatibleRetryEnabled(invocation)) {
                retry = InvokerUtils.getOrCreateCompatibleRetry(invocation);
                CheckedFunction0 supplier = Retry.decorateCheckedSupplier((Retry)retry, (CheckedFunction0 & Serializable)() -> InvokerUtils.innerSyncInvokeImpl(invocation));
                return (Response)Try.of((CheckedFunction0)supplier).get();
            }
            return InvokerUtils.innerSyncInvokeImpl(invocation);
        }
        catch (Throwable e) {
            String message = String.format("invoke failed, operation %s, trace id %s", invocation.getMicroserviceQualifiedName(), invocation.getTraceId());
            LOGGER.error(message, e);
            Response response = Response.createConsumerFail((Throwable)e, (String)message);
            invocation.onFinish(response);
            return response;
        }
    }

    private static boolean isCompatibleRetryEnabled(Invocation invocation) {
        return GovernanceConfiguration.isRetryEnabled(invocation.getMicroserviceName()) && GovernanceConfiguration.getRetryNextServer(invocation.getMicroserviceName()) + GovernanceConfiguration.getRetrySameServer(invocation.getMicroserviceName()) > 0;
    }

    private static Retry getOrCreateCompatibleRetry(Invocation invocation) {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(GovernanceConfiguration.getRetryNextServer(invocation.getMicroserviceName()) + GovernanceConfiguration.getRetrySameServer(invocation.getMicroserviceName()) + 1).retryOnResult(InvokerUtils::canRetryForStatusCode).retryOnException(InvokerUtils::canRetryForException).waitDuration(Duration.ofMillis(GovernanceConfiguration.getWithDuration(invocation.getMicroserviceName()))).build();
        RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
        return retryRegistry.retry(invocation.getMicroserviceName());
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        invocation.setSync(false);
        Supplier<CompletionStage<Response>> next = InvokerUtils.reactiveInvokeImpl(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest(invocation);
        InvokerUtils.decorateReactiveRetry(invocation, (Decorators.DecorateCompletionStage<Response>)dcs, request);
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                asyncResp.complete(r);
                return;
            }
            String message = String.format("invoke failed, operation %s, trace id %s", invocation.getMicroserviceQualifiedName(), invocation.getTraceId());
            LOGGER.error(message, e);
            Response response = Response.createConsumerFail((Throwable)e, (String)message);
            invocation.onFinish(response);
            asyncResp.complete(response);
        });
    }

    private static void decorateReactiveRetry(Invocation invocation, Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        Retry retry;
        if (retryHandler == null) {
            retryHandler = (RetryHandler)BeanUtils.getBean(RetryHandler.class);
        }
        if ((retry = (Retry)retryHandler.getActuator(request)) != null) {
            dcs.withRetry(retry, InvokerUtils.getOrCreateRetryPool());
        }
        if (InvokerUtils.isCompatibleRetryEnabled(invocation)) {
            retry = InvokerUtils.getOrCreateCompatibleRetry(invocation);
            dcs.withRetry(retry, InvokerUtils.getOrCreateRetryPool());
        }
    }

    private static Supplier<CompletionStage<Response>> reactiveInvokeImpl(Invocation invocation) {
        return () -> {
            CompletableFuture result = new CompletableFuture();
            try {
                invocation.onStart(null, System.nanoTime());
                InvokerUtils.updateRetryStatus(invocation);
                ReactiveResponseExecutor respExecutor = new ReactiveResponseExecutor();
                invocation.setResponseExecutor(respExecutor);
                invocation.onStartHandlersRequest();
                invocation.next(ar -> {
                    ContextUtils.setInvocationContext((InvocationContext)invocation.getParentContext());
                    invocation.getInvocationStageTrace().finishHandlersResponse();
                    invocation.onFinish(ar);
                    try {
                        if (ar.getStatusCode() == 101) {
                            ar.setStatus((Response.StatusType)Response.Status.OK);
                        }
                        if (ar.isFailed()) {
                            if (!(ar.getResult() instanceof InvocationException)) {
                                result.completeExceptionally((Throwable)ar.getResult());
                                return;
                            }
                            if (((InvocationException)ar.getResult()).getStatusCode() == 490) {
                                result.completeExceptionally((Throwable)ar.getResult());
                                return;
                            }
                        }
                        result.complete(ar);
                    }
                    finally {
                        ContextUtils.removeInvocationContext();
                    }
                });
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
            return result;
        };
    }

    public static boolean isSyncMethod(@Nonnull Method method) {
        return !InvokerUtils.isAsyncMethod(method);
    }

    public static boolean isAsyncMethod(@Nonnull Method method) {
        return method.getReturnType().equals(CompletableFuture.class);
    }

    public static CompletableFuture<Response> invoke(Invocation invocation) {
        Supplier<CompletionStage<Response>> next = InvokerUtils.invokeImpl(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest(invocation);
        InvokerUtils.decorateReactiveRetry(invocation, (Decorators.DecorateCompletionStage<Response>)dcs, request);
        CompletableFuture<Response> result = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                result.complete((Response)r);
                return;
            }
            String message = String.format("invoke failed, operation %s, trace id %s", invocation.getMicroserviceQualifiedName(), invocation.getTraceId());
            LOGGER.error(message, e);
            Response response = Response.createConsumerFail((Throwable)e, (String)message);
            invocation.onFinish(response);
            result.complete(response);
        });
        return result;
    }

    private static Supplier<CompletionStage<Response>> invokeImpl(Invocation invocation) {
        return () -> {
            invocation.onStart(null, System.nanoTime());
            InvokerUtils.updateRetryStatus(invocation);
            invocation.onStartHandlersRequest();
            return ((CompletableFuture)invocation.getMicroserviceMeta().getFilterChain().onFilter(invocation).exceptionally(throwable -> Exceptions.toConsumerResponse(invocation, throwable))).whenComplete((response, throwable) -> InvokerUtils.finishInvocation(invocation, response));
        };
    }

    private static void finishInvocation(Invocation invocation, Response ar) {
        invocation.getInvocationStageTrace().finishHandlersResponse();
        invocation.onFinish(ar);
        if (ar.isFailed()) {
            if (!(ar.getResult() instanceof InvocationException)) {
                AsyncUtils.rethrow((Throwable)((Throwable)ar.getResult()));
                return;
            }
            if (((InvocationException)ar.getResult()).getStatusCode() == 490) {
                AsyncUtils.rethrow((Throwable)((Throwable)ar.getResult()));
            }
        }
    }

    @VisibleForTesting
    static boolean canRetryForException(Throwable e) {
        if (e instanceof InvocationException && ((InvocationException)e).getStatusCode() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            return true;
        }
        return FailurePredictor.canRetryForException((Map)FailurePredictor.STRICT_RETRIABLE, (Throwable)e);
    }

    @VisibleForTesting
    static boolean canRetryForStatusCode(Object response) {
        if (!(response instanceof Response)) {
            return false;
        }
        Response resp = (Response)response;
        if (!resp.isFailed()) {
            return false;
        }
        if (resp.getResult() instanceof InvocationException) {
            InvocationException e = (InvocationException)resp.getResult();
            return e.getStatusCode() == 503;
        }
        return false;
    }

    static {
        retryHandler = null;
        ENABLE_EVENT_LOOP_BLOCKING_CALL_CHECK = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.invocation.enableEventLoopBlockingCallCheck", true).get();
    }
}

