/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import javax.measure.Quantity;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.internal.CompoundTransform;
import org.apache.sis.coverage.internal.shared.SampleDimensions;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.image.internal.shared.ColorScaleBuilder;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class Visualization
extends ResampledImage {
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;

    private static Interpolation combine(Interpolation interpolation, MathTransform1D[] converters) {
        MathTransform converter = CompoundTransform.create((MathTransform[])converters);
        if (converter.isIdentity()) {
            return interpolation;
        }
        if (converter instanceof MathTransform1D) {
            return new InterpConvertOneBand(interpolation, (MathTransform1D)converter);
        }
        return new InterpConvert(interpolation, converter);
    }

    private Visualization(Builder builder) {
        super(builder.source, builder.sampleModel, builder.layout.getPreferredMinTile(), builder.bounds, builder.toSource, builder.interpolation, builder.fillValues, builder.positionalAccuracyHints);
        this.colorModel = builder.colorModel;
        this.converters = builder.converters;
    }

    @Override
    final boolean hasNoMask() {
        return !(this.interpolation instanceof InterpConvert) && super.hasNoMask();
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) throws TransformException {
        if (this.converters == null) {
            try {
                return super.computeTile(tileX, tileY, tile);
            }
            catch (BackingStoreException e) {
                throw (TransformException)((Object)e.unwrapOrRethrow(TransformException.class));
            }
        }
        if (tile == null) {
            tile = this.createTile(tileX, tileY);
        }
        Transferer.create(this.getSource(), tile).compute(this.converters);
        return tile;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            Visualization other = (Visualization)object;
            return Arrays.equals(this.converters, other.converters) && Objects.equals(this.colorModel, other.colorModel);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 67 * Arrays.hashCode(this.converters) + 97 * Objects.hashCode(this.colorModel);
    }

    private static final class InterpConvertOneBand
    extends InterpConvert {
        private final MathTransform1D singleConverter;

        InterpConvertOneBand(Interpolation interpolation, MathTransform1D converter) {
            super(interpolation, (MathTransform)converter);
            this.singleConverter = converter;
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            this.interpolation.interpolate(source, numBands, xfrac, yfrac, writeTo, writeToOffset);
            try {
                writeTo[writeToOffset] = this.singleConverter.transform(writeTo[writeToOffset]);
            }
            catch (TransformException e) {
                throw new BackingStoreException((Throwable)e);
            }
        }
    }

    static class InterpConvert
    extends Interpolation {
        final Interpolation interpolation;
        final MathTransform converter;

        InterpConvert(Interpolation interpolation, MathTransform converter) {
            this.interpolation = interpolation;
            this.converter = converter;
        }

        @Override
        public final Dimension getSupportSize() {
            return this.interpolation.getSupportSize();
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            this.interpolation.interpolate(source, numBands, xfrac, yfrac, writeTo, writeToOffset);
            try {
                this.converter.transform(writeTo, writeToOffset, writeTo, writeToOffset, 1);
            }
            catch (TransformException e) {
                throw new BackingStoreException((Throwable)e);
            }
        }

        @Override
        Interpolation toCompatible(RenderedImage source) {
            return this;
        }
    }

    static final class Builder {
        private static final int NUM_BANDS = 1;
        private static final int VISIBLE_BAND = 0;
        private Rectangle bounds;
        private RenderedImage source;
        private MathTransform toSource;
        private List<SampleDimension> sampleDimensions;
        ImageLayout layout;
        Interpolation interpolation;
        Colorizer colorizer;
        Number[] fillValues;
        Quantity<?>[] positionalAccuracyHints;
        private MathTransform1D[] converters;
        private SampleModel sampleModel;
        private ColorModel colorModel;

        Builder(Rectangle bounds, RenderedImage source, MathTransform toSource) {
            Object ranges;
            this.bounds = bounds;
            this.source = source;
            this.toSource = toSource;
            this.sampleDimensions = SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.get();
            if (this.sampleDimensions == null && (ranges = source.getProperty("org.apache.sis.SampleDimensions")) instanceof SampleDimension[]) {
                this.sampleDimensions = Containers.viewAsUnmodifiableList((Object[])((SampleDimension[])ranges));
            }
        }

        RenderedImage create(ImageProcessor processor) throws NoninvertibleTransformException {
            boolean initialized;
            ColorScaleBuilder builder;
            boolean shortcut;
            SampleDimension visibleSD;
            RenderedImage coloredSource = this.source;
            int visibleBand = ImageUtilities.getVisibleBand(coloredSource);
            if (visibleBand < 0) {
                throw new IllegalArgumentException(Resources.format((short)55));
            }
            if (this.toSource == null) {
                this.toSource = MathTransforms.identity((int)2);
            }
            while (true) {
                if (this.source instanceof ImageAdapter) {
                    this.source = ((ImageAdapter)this.source).source;
                    continue;
                }
                if (!(this.source instanceof ResampledImage)) break;
                ResampledImage resampled = (ResampledImage)this.source;
                this.toSource = MathTransforms.concatenate((MathTransform)this.toSource, (MathTransform)resampled.toSource);
                this.source = resampled.getSource();
            }
            this.source = BandSelectImage.create(this.source, true, visibleBand);
            SampleDimension sampleDimension = visibleSD = this.sampleDimensions != null && visibleBand < this.sampleDimensions.size() ? this.sampleDimensions.get(visibleBand) : null;
            if (this.bounds == null) {
                this.bounds = ImageUtilities.getBounds(this.source);
                shortcut = this.toSource.isIdentity();
            } else {
                boolean bl = shortcut = this.toSource.isIdentity() && ImageUtilities.getBounds(this.source).contains(this.bounds);
            }
            if (shortcut) {
                this.layout = ImageLayout.DEFAULT.withTileMatrix(this.source).allowTileSizeAdjustments(false);
            }
            DataType dataType = DataType.forDataBufferType(0);
            this.sampleModel = this.layout.createSampleModel(dataType, this.bounds, 1);
            Target target = new Target(this.sampleModel, 0, visibleSD != null);
            if (this.colorizer != null) {
                this.colorModel = this.colorizer.apply(target).orElse(null);
            }
            SampleModel sourceSM = coloredSource.getSampleModel();
            ColorModel sourceCM = coloredSource.getColorModel();
            if (target.rangeColors != null) {
                builder = new ColorScaleBuilder(target.rangeColors, sourceCM);
                initialized = true;
            } else {
                builder = new ColorScaleBuilder(target.categoryColors, sourceCM, true);
                initialized = builder.initialize(sourceSM, visibleSD);
                if (initialized) {
                    builder.rescaleMainRange(sourceCM);
                } else {
                    initialized = builder.initialize(sourceCM);
                    if (!initialized) {
                        if (coloredSource instanceof RecoloredImage) {
                            RecoloredImage colored = (RecoloredImage)coloredSource;
                            if (colored.minimum < colored.maximum) {
                                builder.initialize(colored.minimum, colored.maximum, sourceSM.getDataType());
                                initialized = true;
                            }
                        }
                        if (!initialized) {
                            initialized = builder.initialize(sourceSM, visibleBand);
                        }
                    }
                }
            }
            if (!initialized) {
                DoubleUnaryOperator[] sampleFilters = SampleDimensions.toSampleFilters(Collections.singletonList(visibleSD));
                Statistics statistics = processor.valueOfStatistics(this.source, null, sampleFilters)[0];
                builder.initialize(statistics.minimum(), statistics.maximum(), sourceSM.getDataType());
            }
            if (this.colorModel == null) {
                this.colorModel = builder.createColorModel(dataType, 1, 0);
            }
            this.converters = new MathTransform1D[]{builder.getSampleToIndexValues()};
            if (shortcut) {
                if (this.converters[0].isIdentity() && this.colorModel.equals(sourceCM)) {
                    return coloredSource;
                }
                this.interpolation = Interpolation.NEAREST;
            } else {
                this.interpolation = Visualization.combine(this.interpolation.toCompatible(this.source), this.converters);
                this.converters = null;
            }
            return ImageProcessor.unique(new Visualization(this));
        }
    }

    static final class Target
    extends Colorizer.Target {
        List<Map.Entry<NumberRange<?>, Color[]>> rangeColors;
        Function<Category, Color[]> categoryColors;
        private final boolean hasCategories;

        Target(SampleModel model, int visibleBand, boolean hasCategories) {
            super(model, null, visibleBand);
            this.hasCategories = hasCategories;
        }

        @Override
        boolean isConsumed() {
            return this.rangeColors != null || this.hasCategories && this.categoryColors != null;
        }
    }
}

