/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.apache.sling.graphql.api.SchemaProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={RankedSchemaProviders.class})
public class RankedSchemaProviders
implements SchemaProvider {
    final RankedServices<SchemaProvider> providers = new RankedServices(Order.DESCENDING);

    @Override
    @Nullable
    public String getSchema(@NotNull Resource r, @Nullable String[] selectors) throws IOException {
        SchemaProvider p;
        String result = null;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext() && (result = (p = (SchemaProvider)iterator.next()).getSchema(r, selectors)) == null) {
        }
        if (result == null) {
            String selectorsInfo = selectors == null ? null : " / " + Arrays.asList(selectors);
            throw new IOException("No schema found for " + r.getPath() + selectorsInfo + ", SchemaProviders=" + this.providers);
        }
        return result;
    }

    @Reference(service=SchemaProvider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindSchemaProvider(SchemaProvider service, Map<String, Object> props) {
        this.providers.bind((Object)service, props);
    }

    protected void unbindSchemaProvider(SchemaProvider service, Map<String, Object> props) {
        this.providers.unbind((Object)service, props);
    }
}

