/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi2davex.ItemInfoImpl;

public class PropertyInfoImpl
extends ItemInfoImpl
implements PropertyInfo {
    private final boolean multiValued;
    private PropertyId id;
    private int propertyType;
    private QValue[] values = QValue.EMPTY_ARRAY;

    public PropertyInfoImpl(PropertyId id, Path path, int propertyType, QValue value) throws RepositoryException {
        super(path, false);
        this.id = id;
        this.propertyType = propertyType;
        this.multiValued = false;
        this.values = new QValue[]{value};
    }

    public PropertyInfoImpl(PropertyId id, Path path, int propertyType, QValue[] values) throws RepositoryException {
        super(path, false);
        this.id = id;
        this.propertyType = propertyType;
        this.values = values;
        this.multiValued = true;
    }

    @Override
    public PropertyId getId() {
        return this.id;
    }

    @Override
    public int getType() {
        if (this.propertyType == 0) {
            this.propertyType = this.getValues()[0].getType();
        }
        return this.propertyType;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public QValue[] getValues() {
        return this.values;
    }

    void setId(PropertyId id) {
        this.id = id;
    }

    void checkCompleted() throws RepositoryException {
        if (this.id == null) {
            throw new RepositoryException("Incomplete PropertyInfo: id missing.");
        }
        if (this.propertyType == 0) {
            throw new RepositoryException("Incomplete PropertyInfo: missing type of property.");
        }
    }
}

