/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ServicePropertiesMap;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.impl.via.BeanPropertyViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.apache.sling.models.testmodels.classes.InjectorSpecificAnnotationModel;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
class InjectorSpecificAnnotationTest {
    @Mock
    private BundleContext bundleContext;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private Logger log;
    private ModelAdapterFactory factory;
    private OSGiServiceInjector osgiInjector;

    InjectorSpecificAnnotationTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.osgiInjector = new OSGiServiceInjector();
        this.osgiInjector.activate(this.bundleContext);
        BindingsInjector bindingsInjector = new BindingsInjector();
        ValueMapInjector valueMapInjector = new ValueMapInjector();
        ChildResourceInjector childResourceInjector = new ChildResourceInjector();
        RequestAttributeInjector requestAttributeInjector = new RequestAttributeInjector();
        this.factory.injectors = Arrays.asList(bindingsInjector, valueMapInjector, childResourceInjector, requestAttributeInjector, this.osgiInjector);
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)bindingsInjector, (Map)new ServicePropertiesMap(1L, 0));
        this.factory.injectAnnotationProcessorFactories = Collections.singletonList(valueMapInjector);
        this.factory.injectAnnotationProcessorFactories2 = Collections.singletonList(childResourceInjector);
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)requestAttributeInjector, (Map)new ServicePropertiesMap(4L, 0));
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)this.osgiInjector, (Map)new ServicePropertiesMap(5L, 0));
        this.factory.bindViaProvider((ViaProvider)new BeanPropertyViaProvider(), null);
        SlingBindings bindings = new SlingBindings();
        bindings.setLog(this.log);
        Mockito.when((Object)this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{InjectorSpecificAnnotationModel.class, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class});
    }

    @Test
    void testSimpleValueModelField() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("second", "second-value");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assert.assertEquals((Object)"second-value", (Object)model.getSecond());
    }

    @Test
    void testOrderForValueAnnotationField() {
        Logger logFromValueMap = LoggerFactory.getLogger(this.getClass());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("log", (String)logFromValueMap);
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assert.assertEquals((Object)logFromValueMap, (Object)model.getLog());
    }

    @Test
    void testOSGiServiceField() throws InvalidSyntaxException {
        ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.bundleContext.getServiceReferences(Logger.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref});
        ((BundleContext)Mockito.doReturn((Object)logger).when((Object)this.bundleContext)).getService(ref);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)logger, (Object)model.getService());
    }

    @Test
    void testScriptVariableField() {
        SlingBindings bindings = new SlingBindings();
        SlingScriptHelper helper = (SlingScriptHelper)Mockito.mock(SlingScriptHelper.class);
        bindings.setSling(helper);
        Mockito.when((Object)this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)helper, (Object)model.getHelper());
    }

    @Test
    void testRequestAttributeField() {
        Object attribute = new Object();
        Mockito.when((Object)this.request.getAttribute("attribute")).thenReturn(attribute);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)attribute, (Object)model.getRequestAttribute());
    }

    @Test
    void testChildResourceField() {
        Resource res = (Resource)Mockito.mock(Resource.class);
        Resource child = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("child1")).thenReturn((Object)child);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        InjectorSpecificAnnotationModel model = (InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)child, (Object)model.getChildResource());
    }

    @Test
    void testSimpleValueModelConstructor() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("second", "second-value");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assert.assertEquals((Object)"second-value", (Object)model.getSecond());
    }

    @Test
    void testOrderForValueAnnotationConstructor() {
        Logger logFromValueMap = LoggerFactory.getLogger(this.getClass());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("log", (String)logFromValueMap);
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assert.assertEquals((Object)logFromValueMap, (Object)model.getLog());
    }

    @Test
    void testOSGiServiceConstructor() throws InvalidSyntaxException {
        ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.bundleContext.getServiceReferences(Logger.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref});
        ((BundleContext)Mockito.doReturn((Object)logger).when((Object)this.bundleContext)).getService(ref);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)logger, (Object)model.getService());
    }

    @Test
    void testScriptVariableConstructor() {
        SlingBindings bindings = new SlingBindings();
        SlingScriptHelper helper = (SlingScriptHelper)Mockito.mock(SlingScriptHelper.class);
        bindings.setSling(helper);
        Mockito.when((Object)this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)helper, (Object)model.getHelper());
    }

    @Test
    void testRequestAttributeConstructor() {
        Object attribute = new Object();
        Mockito.when((Object)this.request.getAttribute("attribute")).thenReturn(attribute);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)attribute, (Object)model.getRequestAttribute());
    }

    @Test
    void testChildResourceConstructor() {
        Resource res = (Resource)Mockito.mock(Resource.class);
        Resource child = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("child1")).thenReturn((Object)child);
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)res);
        org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.constructorinjection.InjectorSpecificAnnotationModel.class);
        Assert.assertNotNull((String)"Could not instanciate model", (Object)model);
        Assert.assertEquals((Object)child, (Object)model.getChildResource());
    }
}

