/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.function.IntSupplier;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.FirstImplementationPicker;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.testutil.ModelAdapterFactoryUtil;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={OsgiContextExtension.class, MockitoExtension.class})
class ModelAdapterFactory_ImplementationPickerOrderTest {
    final OsgiContext context = new OsgiContext();
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @Mock
    private SlingJakartaHttpServletRequest request;
    private ModelAdapterFactory factory;

    ModelAdapterFactory_ImplementationPickerOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.context.registerService(BindingsValuesProvidersByContext.class, (Object)this.bindingsValuesProvidersByContext);
        this.context.registerService(AdapterManager.class, (Object)this.adapterManager);
        this.factory = (ModelAdapterFactory)this.context.registerInjectActivateService(ModelAdapterFactory.class);
        ModelAdapterFactoryUtil.addModelsForPackage(this.context.bundleContext(), Model1.class, Model2.class);
    }

    @Test
    void testFirstImplementationPicker() {
        this.context.registerService(ImplementationPicker.class, (Object)new FirstImplementationPicker(), new Object[]{"service.ranking", Integer.MAX_VALUE});
        IntSupplier result = (IntSupplier)this.factory.createModel((Object)this.request, IntSupplier.class);
        Assert.assertEquals((long)1L, (long)result.getAsInt());
    }

    @Test
    void testMultipleImplementationPickers() {
        this.context.registerService(ImplementationPicker.class, (Object)new FirstImplementationPicker(), new Object[]{"service.ranking", Integer.MAX_VALUE});
        this.context.registerService(ImplementationPicker.class, (Object)new LastImplementationPicker(), new Object[]{"service.ranking", 100});
        IntSupplier result = (IntSupplier)this.factory.createModel((Object)this.request, IntSupplier.class);
        Assert.assertEquals((long)2L, (long)result.getAsInt());
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class}, adapters={IntSupplier.class})
    static final class Model1
    implements IntSupplier {
        Model1() {
        }

        @Override
        public int getAsInt() {
            return 1;
        }
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class}, adapters={IntSupplier.class})
    static final class Model2
    implements IntSupplier {
        Model2() {
        }

        @Override
        public int getAsInt() {
            return 2;
        }
    }

    static final class LastImplementationPicker
    implements ImplementationPicker {
        LastImplementationPicker() {
        }

        public Class<?> pick(@NotNull Class<?> adapterType, Class<?>[] implementationsTypes, @NotNull Object adaptable) {
            return implementationsTypes[implementationsTypes.length - 1];
        }
    }
}

