/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.testmodels.classes.DirectCyclicSelfDependencyModel;
import org.apache.sling.models.testmodels.classes.IndirectCyclicSelfDependencyModelA;
import org.apache.sling.models.testmodels.classes.IndirectCyclicSelfDependencyModelB;
import org.apache.sling.models.testmodels.classes.SelfDependencyModelA;
import org.apache.sling.models.testmodels.classes.SelfDependencyModelB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;

@ExtendWith(value={MockitoExtension.class})
class SelfDependencyTest {
    private ModelAdapterFactory factory;
    @Mock
    private SlingJakartaHttpServletRequest request;

    SelfDependencyTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.lenient().when(this.request.adaptTo((Class)ArgumentMatchers.any(Class.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Class clazz = (Class)invocation.getArguments()[0];
                return SelfDependencyTest.this.factory.getAdapter((Object)SelfDependencyTest.this.request, clazz);
            }
        });
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Collections.singletonList(new SelfInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SelfDependencyModelA.class, SelfDependencyModelB.class, DirectCyclicSelfDependencyModel.class, IndirectCyclicSelfDependencyModelA.class, IndirectCyclicSelfDependencyModelB.class});
    }

    @Test
    void testChainedSelfDependency() {
        SelfDependencyModelA objectA = (SelfDependencyModelA)this.factory.getAdapter((Object)this.request, SelfDependencyModelA.class);
        Assertions.assertNotNull((Object)objectA);
        SelfDependencyModelB objectB = objectA.getDependencyB();
        Assertions.assertNotNull((Object)objectB);
        Assertions.assertSame((Object)this.request, (Object)objectB.getRequest());
    }

    @Test
    void testDirectCyclicSelfDependency() {
        DirectCyclicSelfDependencyModel object = (DirectCyclicSelfDependencyModel)this.factory.getAdapter((Object)this.request, DirectCyclicSelfDependencyModel.class);
        Assertions.assertNull((Object)object);
    }

    @Test
    void testInddirectCyclicSelfDependency() {
        IndirectCyclicSelfDependencyModelA object = (IndirectCyclicSelfDependencyModelA)this.factory.getAdapter((Object)this.request, IndirectCyclicSelfDependencyModelA.class);
        Assertions.assertNull((Object)object);
    }
}

