/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.models.annotations.via.OriginalResourceType;
import org.apache.sling.models.impl.via.OriginalResourceTypeViaProvider;
import org.apache.sling.models.impl.via.ResourceTypeForcingJakartaRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingResourceWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OriginalResourceTypeViaProviderTest {
    private OriginalResourceTypeViaProvider provider = new OriginalResourceTypeViaProvider();
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest request;

    OriginalResourceTypeViaProviderTest() {
    }

    @Test
    void testReturnsCorrectMarkerInterface() {
        Assertions.assertEquals(OriginalResourceType.class, (Object)this.provider.getType());
    }

    @Test
    void testReturnsOriginalResourceIfNotWrapped() {
        Object projected = this.provider.getAdaptable((Object)this.resource, null);
        Assertions.assertEquals((Object)this.resource, (Object)projected);
    }

    @Test
    void testReturnsOriginalRequestIfNotWrapped() {
        Object projected = this.provider.getAdaptable((Object)this.request, null);
        Assertions.assertEquals((Object)this.request, (Object)projected);
    }

    @Test
    void testReturnsNullIfNeitherRequestOrResource() {
        Object projected = this.provider.getAdaptable(new Object(), null);
        Assertions.assertNull((Object)projected);
    }

    @Test
    void testUnwrapsResource() {
        ResourceTypeForcingResourceWrapper testCase = new ResourceTypeForcingResourceWrapper(this.resource, "foo");
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)this.resource, (Object)projected);
        testCase = new ResourceTypeForcingResourceWrapper((Resource)testCase, "bar");
        testCase = new ResourceTypeForcingResourceWrapper((Resource)testCase, "foobar");
        projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)this.resource, (Object)projected);
    }

    @Test
    void testUnwrapsJakartaRequest() {
        ResourceTypeForcingJakartaRequestWrapper testCase = new ResourceTypeForcingJakartaRequestWrapper(this.request, this.resource, "foo");
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)this.request, (Object)projected);
        testCase = new ResourceTypeForcingJakartaRequestWrapper((SlingJakartaHttpServletRequest)testCase, this.resource, "bar");
        testCase = new ResourceTypeForcingJakartaRequestWrapper((SlingJakartaHttpServletRequest)testCase, this.resource, "foobar");
        projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)this.request, (Object)projected);
    }

    @Deprecated
    @Test
    void testUnwrapsJavaxRequest() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        ResourceTypeForcingRequestWrapper testCase = new ResourceTypeForcingRequestWrapper(javaxRequest, this.resource, "foo");
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)javaxRequest, (Object)projected);
        testCase = new ResourceTypeForcingRequestWrapper((SlingHttpServletRequest)testCase, this.resource, "bar");
        testCase = new ResourceTypeForcingRequestWrapper((SlingHttpServletRequest)testCase, this.resource, "foobar");
        projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)javaxRequest, (Object)projected);
    }

    @Test
    void testDoesNotUnwrapOtherResourceWrappers() {
        ResourceWrapper testCase = new ResourceWrapper(this.resource);
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)testCase, (Object)projected);
    }

    @Test
    void testDoesNotUnwrapOtherJakartaRequestWrappers() {
        SlingJakartaHttpServletRequestWrapper testCase = new SlingJakartaHttpServletRequestWrapper(this.request);
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)testCase, (Object)projected);
    }

    @Deprecated
    @Test
    void testDoesNotUnwrapOtherJavaxRequestWrappers() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        SlingHttpServletRequestWrapper testCase = new SlingHttpServletRequestWrapper(javaxRequest);
        Object projected = this.provider.getAdaptable((Object)testCase, null);
        Assertions.assertEquals((Object)testCase, (Object)projected);
    }
}

