/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import jakarta.servlet.Servlet;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ModelConfigurationPrinter {
    private static final String EXPORT_SERVLET_FILTER = "(sling.models.exporter.servlet.class=*)";
    private final ModelAdapterFactory modelAdapterFactory;
    private final BundleContext bundleContext;
    private final AdapterImplementations adapterImplementations;

    ModelConfigurationPrinter(ModelAdapterFactory modelAdapterFactory, BundleContext bundleContext, AdapterImplementations adapterImplementations) {
        this.modelAdapterFactory = modelAdapterFactory;
        this.bundleContext = bundleContext;
        this.adapterImplementations = adapterImplementations;
    }

    private String propertyToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    public void printConfiguration(PrintWriter printWriter) {
        printWriter.println("Sling Models Injectors:");
        Collection<Injector> injectors = this.modelAdapterFactory.getInjectors();
        if (injectors.isEmpty()) {
            printWriter.println("none");
        } else {
            for (Injector injector : injectors) {
                printWriter.printf("%s - %s", injector.getName(), injector.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Inject Annotation Processor Factories:");
        Collection<InjectAnnotationProcessorFactory> factories = this.modelAdapterFactory.getInjectAnnotationProcessorFactories();
        Collection<InjectAnnotationProcessorFactory2> factories2 = this.modelAdapterFactory.getInjectAnnotationProcessorFactories2();
        Collection<StaticInjectAnnotationProcessorFactory> staticFactories = this.modelAdapterFactory.getStaticInjectAnnotationProcessorFactories();
        if (factories.isEmpty() && factories2.isEmpty() && staticFactories.isEmpty()) {
            printWriter.println("none");
        } else {
            for (StaticInjectAnnotationProcessorFactory staticInjectAnnotationProcessorFactory : staticFactories) {
                printWriter.printf("%s", staticInjectAnnotationProcessorFactory.getClass().getName());
                printWriter.println();
            }
            for (InjectAnnotationProcessorFactory2 injectAnnotationProcessorFactory2 : factories2) {
                printWriter.printf("%s", injectAnnotationProcessorFactory2.getClass().getName());
                printWriter.println();
            }
            for (InjectAnnotationProcessorFactory injectAnnotationProcessorFactory : factories) {
                printWriter.printf("%s", injectAnnotationProcessorFactory.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Implementation Pickers:");
        List<ImplementationPicker> pickers = this.modelAdapterFactory.getImplementationPickers();
        if (pickers.size() == 0) {
            printWriter.println("none");
        } else {
            for (ImplementationPicker implementationPicker : pickers) {
                printWriter.printf("%s", implementationPicker.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Via Providers:");
        Map<Class<? extends ViaProviderType>, ViaProvider> map = this.modelAdapterFactory.getViaProviders();
        if (map == null || map.size() == 0) {
            printWriter.println("none");
        } else {
            for (Map.Entry<Class<? extends ViaProviderType>, ViaProvider> entry : map.entrySet()) {
                printWriter.printf("%s (Type: %s)", entry.getValue().getClass().getName(), entry.getKey().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Bound to Resource Types *For Resources*:");
        for (Map.Entry<String, Class<?>> entry : this.adapterImplementations.getResourceTypeMappingsForResources().entrySet()) {
            printWriter.print(entry.getValue().getName());
            printWriter.print(" - ");
            printWriter.println(entry.getKey());
        }
        printWriter.println();
        printWriter.println("Sling Models Bound to Resource Types *For Requests*:");
        for (Map.Entry<String, Class<?>> entry : this.adapterImplementations.getResourceTypeMappingsForRequests().entrySet()) {
            printWriter.print(entry.getValue().getName());
            printWriter.print(" - ");
            printWriter.println(entry.getKey());
        }
        printWriter.println();
        printWriter.println("Sling Models Exporter Servlets:");
        try {
            ServiceReference[] serviceReferenceArray = this.bundleContext.getServiceReferences(Servlet.class.getName(), EXPORT_SERVLET_FILTER);
            if (serviceReferenceArray != null) {
                for (ServiceReference ref : serviceReferenceArray) {
                    printWriter.print(this.propertyToString(ref.getProperty("sling.models.exporter.servlet.class")));
                    printWriter.print(" exports '");
                    printWriter.print(this.propertyToString(ref.getProperty("sling.servlet.resourceTypes")));
                    printWriter.print("' with selector '");
                    printWriter.print(this.propertyToString(ref.getProperty("sling.servlet.selectors")));
                    printWriter.print("' and extension '");
                    printWriter.print(this.propertyToString(ref.getProperty("sling.servlet.extensions")));
                    printWriter.print("' with exporter '");
                    printWriter.print(this.propertyToString(ref.getProperty("sling.models.exporter.servlet.name")));
                    printWriter.println("'");
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }
}

