/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntries;
import org.apache.sling.resourceresolver.impl.mapping.PagedQueryIterator;
import org.apache.sling.resourceresolver.impl.mapping.QueryBuildHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AliasHandler {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_PREFIX = "jcr:content/";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String SERVICE_USER = "mapping";
    private MapConfigurationProvider factory;
    private final ReentrantLock initializing;
    private final Logger log = LoggerFactory.getLogger(AliasHandler.class);
    private static final int MAX_REPORT_DEFUNCT_ALIASES = 50;
    private final Runnable doUpdateConfiguration;
    private final Runnable sendChangeEvent;
    private final Consumer<String> drain;
    private static final Map<String, Map<String, Collection<String>>> UNITIALIZED_MAP = Collections.emptyMap();
    @NotNull
    Map<String, Map<String, Collection<String>>> aliasMapsMap = UNITIALIZED_MAP;
    final AtomicLong aliasResourcesOnStartup;
    final AtomicLong detectedConflictingAliases;
    final AtomicLong detectedInvalidAliases;
    private final AtomicBoolean aliasesProcessed = new AtomicBoolean(false);

    public AliasHandler(@NotNull MapConfigurationProvider factory, @NotNull ReentrantLock initializing, @NotNull Runnable doUpdateConfiguration, @NotNull Runnable sendChangeEvent, @NotNull Consumer<String> drain) {
        this.factory = factory;
        this.initializing = initializing;
        this.doUpdateConfiguration = doUpdateConfiguration;
        this.sendChangeEvent = sendChangeEvent;
        this.drain = drain;
        this.aliasResourcesOnStartup = new AtomicLong(0L);
        this.detectedConflictingAliases = new AtomicLong(0L);
        this.detectedInvalidAliases = new AtomicLong(0L);
    }

    public boolean isReady() {
        return this.aliasesProcessed.get();
    }

    public void dispose() {
        this.factory = null;
    }

    protected void initializeAliases() {
        this.initializing.lock();
        this.aliasMapsMap = UNITIALIZED_MAP;
        if (this.factory == null) {
            this.log.error("Can't initialize aliases when MapConfigurationProvider is null");
            return;
        }
        this.log.info("Initializing Aliases ({}={}, {}={}, {}={})", new Object[]{"alias_cache_in_background", this.factory.isAliasCacheInitInBackground(), "optimize_alias_resolution", this.factory.isOptimizeAliasResolutionEnabled(), "allowed_alias_locations", this.factory.getAllowedAliasLocations()});
        try {
            this.aliasesProcessed.set(false);
            if (this.factory.isOptimizeAliasResolutionEnabled()) {
                AliasInitializer ai = new AliasInitializer();
                if (this.factory.isAliasCacheInitInBackground()) {
                    this.log.debug("starting alias initialization in the background");
                    Thread aiinit = new Thread((Runnable)ai, "AliasInitializer");
                    aiinit.start();
                } else {
                    ai.run();
                }
            }
            this.doUpdateConfiguration.run();
            this.sendChangeEvent.run();
        }
        finally {
            this.initializing.unlock();
        }
    }

    boolean usesCache() {
        return this.aliasMapsMap != UNITIALIZED_MAP;
    }

    boolean doAddAlias(@NotNull Resource resource) {
        if (this.usesCache()) {
            return this.loadAlias(resource, this.aliasMapsMap, null, null);
        }
        return false;
    }

    boolean removeAlias(@Nullable ResourceResolver resolver, @NotNull String contentPath, @Nullable String path, @NotNull Runnable notifyOfChange) {
        if (this.usesCache()) {
            return this.removeAliasInMap(resolver, contentPath, path, notifyOfChange);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAliasInMap(@Nullable ResourceResolver resolver, @NotNull String contentPath, @Nullable String path, @NotNull Runnable notifyOfChange) {
        String resourcePath = AliasHandler.computeResourcePath(contentPath, path);
        if (resourcePath == null) {
            return false;
        }
        this.initializing.lock();
        try {
            Map<String, Collection<String>> aliasMapEntry = this.aliasMapsMap.get(contentPath);
            if (aliasMapEntry != null) {
                notifyOfChange.run();
                this.handleAliasRemoval(resolver, contentPath, resourcePath, aliasMapEntry);
            }
            boolean bl = aliasMapEntry != null;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    @Nullable
    private static String computeResourcePath(@NotNull String contentPath, @Nullable String path) {
        String resourcePath = null;
        if (path != null && path.length() > contentPath.length()) {
            String subPath = path.substring(contentPath.length() + 1);
            int firstSlash = subPath.indexOf(47);
            if (firstSlash == -1) {
                if (!subPath.equals(JCR_CONTENT)) {
                    resourcePath = path;
                }
            } else if (subPath.lastIndexOf(47) == firstSlash && !subPath.startsWith(JCR_CONTENT_PREFIX) && subPath.endsWith(JCR_CONTENT_SUFFIX)) {
                resourcePath = ResourceUtil.getParent((String)path);
            }
        } else {
            resourcePath = contentPath;
        }
        return resourcePath;
    }

    private void handleAliasRemoval(@Nullable ResourceResolver resolver, @NotNull String contentPath, @NotNull String resourcePath, @NotNull Map<String, Collection<String>> aliasMapEntry) {
        Resource containingResource;
        Object prefix;
        Object object = prefix = contentPath.endsWith("/") ? contentPath : contentPath + "/";
        if (aliasMapEntry.entrySet().removeIf(arg_0 -> AliasHandler.lambda$handleAliasRemoval$0((String)prefix, resourcePath, arg_0)) && aliasMapEntry.isEmpty()) {
            this.aliasMapsMap.remove(contentPath);
        }
        Resource resource = containingResource = resolver != null ? resolver.getResource(resourcePath) : null;
        if (containingResource != null) {
            Resource child;
            if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                this.doAddAlias(containingResource);
            }
            if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                this.doAddAlias(child);
            }
        }
    }

    boolean doUpdateAlias(@NotNull Resource resource) {
        if (this.usesCache()) {
            return this.doUpdateAliasInMap(resource);
        }
        return false;
    }

    private boolean doUpdateAliasInMap(@NotNull Resource resource) {
        Resource containingResource = this.getResourceToBeAliased(resource);
        if (containingResource != null) {
            Resource child;
            boolean changed;
            Map<String, Collection<String>> aliasMapEntry;
            String containingResourceName = containingResource.getName();
            String parentPath = ResourceUtil.getParent((String)containingResource.getPath());
            Map<String, Collection<String>> map = aliasMapEntry = parentPath == null ? null : this.aliasMapsMap.get(parentPath);
            if (aliasMapEntry != null) {
                aliasMapEntry.remove(containingResourceName);
                if (aliasMapEntry.isEmpty()) {
                    this.aliasMapsMap.remove(parentPath);
                }
            }
            boolean bl = changed = aliasMapEntry != null;
            if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(containingResource);
            }
            if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(child);
            }
            return changed;
        }
        this.log.warn("containingResource is null for alias on {}, skipping.", (Object)resource.getPath());
        return false;
    }

    @NotNull
    public Map<String, Collection<String>> getAliasMap(@Nullable String parentPath) {
        Map<String, Collection<String>> result = this.usesCache() ? this.getAliasMapFromCache(parentPath) : this.getAliasMapFromRepo(parentPath);
        return result != null ? result : Collections.emptyMap();
    }

    @NotNull
    public Map<String, Collection<String>> getAliasMap(@NotNull Resource parent) {
        Map<String, Collection<String>> result = this.usesCache() ? this.getAliasMapFromCache(parent.getPath()) : this.getAliasMapFromRepo(parent);
        return result != null ? result : Collections.emptyMap();
    }

    @Nullable
    private Map<String, Collection<String>> getAliasMapFromCache(@Nullable String parentPath) {
        return this.aliasMapsMap.get(parentPath);
    }

    @Nullable
    private Map<String, Collection<String>> getAliasMapFromRepo(@Nullable String parentPath) {
        Map<String, Collection<String>> map;
        block9: {
            if (parentPath == null) {
                return null;
            }
            ResourceResolver resolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo(SERVICE_USER));
            try {
                map = this.getAliasMapFromRepo(resolver.getResource(parentPath));
                if (resolver == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException ex) {
                    this.log.error("Could not obtain resolver to resolve any aliases from repository", (Throwable)ex);
                    return null;
                }
            }
            resolver.close();
        }
        return map;
    }

    @Nullable
    private Map<String, Collection<String>> getAliasMapFromRepo(@Nullable Resource parent) {
        Map result = null;
        if (parent != null) {
            HashMap<String, Map<String, Collection<String>>> localMap = new HashMap<String, Map<String, Collection<String>>>();
            ArrayList<String> throwAwayDiagnostics = new ArrayList<String>();
            for (Resource child : parent.getChildren()) {
                if (JCR_CONTENT.equals(child.getName())) continue;
                this.loadAlias(child, localMap, throwAwayDiagnostics, throwAwayDiagnostics);
                Resource childContentNode = child.getChild(JCR_CONTENT);
                if (childContentNode == null) continue;
                this.loadAlias(childContentNode, localMap, throwAwayDiagnostics, throwAwayDiagnostics);
            }
            result = (Map)localMap.get(parent.getPath());
        }
        return result;
    }

    private boolean loadAlias(@NotNull Resource resource, @NotNull Map<String, Map<String, Collection<String>>> map, @Nullable List<String> conflictingAliases, @Nullable List<String> invalidAliases) {
        Resource containingResource = this.getResourceToBeAliased(resource);
        if (containingResource == null) {
            this.log.warn("containingResource is null for alias on {}, skipping.", (Object)resource.getPath());
            return false;
        }
        String[] aliasArray = (String[])resource.getValueMap().get("sling:alias", String[].class);
        if (aliasArray == null) {
            return false;
        }
        String parentPath = ResourceUtil.getParent((String)containingResource.getPath());
        if (parentPath == null) {
            this.log.debug("the root path cannot have aliases");
            return false;
        }
        return this.loadAliasFromArray(aliasArray, map, conflictingAliases, invalidAliases, containingResource.getName(), parentPath);
    }

    private boolean loadAliasFromArray(@Nullable String[] aliasArray, @NotNull Map<String, Map<String, Collection<String>>> map, @Nullable List<String> conflictingAliases, @Nullable List<String> invalidAliases, @NotNull String resourceName, @NotNull String parentPath) {
        boolean hasAlias = false;
        this.log.debug("Found alias, total size {}", (Object)aliasArray.length);
        for (String alias : aliasArray) {
            if (this.isAliasInvalid(alias)) {
                long invalids = this.detectedInvalidAliases.incrementAndGet();
                this.log.warn("Encountered invalid alias '{}' under parent path '{}' (total so far: {}). Refusing to use it.", new Object[]{alias, parentPath, invalids});
                if (invalidAliases == null || invalids >= 50L) continue;
                invalidAliases.add(String.format("'%s'/'%s'", parentPath, alias));
                continue;
            }
            Map parentMap = map.computeIfAbsent(parentPath, key -> new ConcurrentHashMap());
            Optional<String> siblingResourceNameWithDuplicateAlias = parentMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(resourceName)).filter(entry -> ((Collection)entry.getValue()).contains(alias)).findFirst().map(Map.Entry::getKey);
            if (siblingResourceNameWithDuplicateAlias.isPresent()) {
                long conflicting = this.detectedConflictingAliases.incrementAndGet();
                this.log.warn("Encountered duplicate alias '{}' under parent path '{}'. Refusing to replace current target '{}' with '{}' (total duplicated aliases so far: {}).", new Object[]{alias, parentPath, siblingResourceNameWithDuplicateAlias.get(), resourceName, conflicting});
                if (conflictingAliases == null || conflicting >= 50L) continue;
                conflictingAliases.add(String.format("'%s': '%s'/'%s' vs '%s'/'%s'", parentPath, resourceName, alias, siblingResourceNameWithDuplicateAlias.get(), alias));
                continue;
            }
            Collection existingAliases = parentMap.computeIfAbsent(resourceName, name -> new CopyOnWriteArrayList());
            existingAliases.add(alias);
            hasAlias = true;
        }
        return hasAlias;
    }

    @Nullable
    private Resource getResourceToBeAliased(@NotNull Resource resource) {
        if (JCR_CONTENT.equals(resource.getName())) {
            return resource.getParent();
        }
        return resource;
    }

    private boolean isAliasInvalid(@Nullable String alias) {
        boolean invalid;
        if (alias == null) {
            invalid = true;
        } else {
            boolean bl = invalid = alias.equals("..") || alias.equals(".") || alias.isEmpty();
            if (!invalid) {
                for (char c : alias.toCharArray()) {
                    if (c != '/' && c != '#' && c != '?') continue;
                    invalid = true;
                    break;
                }
            }
        }
        return invalid;
    }

    private static /* synthetic */ boolean lambda$handleAliasRemoval$0(String prefix, String resourcePath, Map.Entry e) {
        return (prefix + (String)e.getKey()).startsWith(resourcePath);
    }

    private class AliasInitializer
    implements Runnable {
        private AliasInitializer() {
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Exception ex) {
                AliasHandler.this.log.error("alias initializer thread terminated with an exception", (Throwable)ex);
            }
        }

        private void execute() {
            try (ResourceResolver resolver = AliasHandler.this.factory.getServiceResourceResolver(AliasHandler.this.factory.getServiceUserAuthenticationInfo(AliasHandler.SERVICE_USER));){
                ArrayList<String> conflictingAliases = new ArrayList<String>();
                ArrayList<String> invalidAliases = new ArrayList<String>();
                StringBuilder diagnostics = new StringBuilder();
                StopWatch sw = StopWatch.createStarted();
                AliasHandler.this.log.debug("alias initialization - start");
                AliasHandler.this.aliasMapsMap = this.loadAliases(resolver, conflictingAliases, invalidAliases, diagnostics);
                AliasHandler.this.drain.accept("draining alias event queue (during cache initialization)");
                AliasHandler.this.aliasesProcessed.set(true);
                AliasHandler.this.drain.accept("draining alias event queue (after cache initialization)");
                String message = MapEntries.getTimingMessage("alias initialization - completed", sw.getDuration(), AliasHandler.this.aliasResourcesOnStartup.get());
                AliasHandler.this.log.info(message);
            }
            catch (Exception ex) {
                AliasHandler.this.log.error("Alias init failed", (Throwable)ex);
                AliasHandler.this.aliasMapsMap = UNITIALIZED_MAP;
            }
        }

        @NotNull
        private Map<String, Map<String, Collection<String>>> loadAliases(@NotNull ResourceResolver resolver, @NotNull List<String> conflictingAliases, @NotNull List<String> invalidAliases, @NotNull StringBuilder diagnostics) {
            Iterator<Resource> it;
            ConcurrentHashMap<String, Map<String, Collection<String>>> map = new ConcurrentHashMap<String, Map<String, Collection<String>>>();
            String baseQueryString = this.generateAliasQuery();
            try {
                String queryStringWithSort = baseQueryString + " AND FIRST([sling:alias]) >= '%s' ORDER BY FIRST([sling:alias])";
                it = new PagedQueryIterator("alias", "sling:alias", resolver, queryStringWithSort, 2000);
            }
            catch (QuerySyntaxException ex) {
                AliasHandler.this.log.debug("sort with first() not supported, falling back to base query", (Throwable)ex);
                it = this.queryUnpaged(baseQueryString, resolver);
            }
            catch (UnsupportedOperationException ex) {
                AliasHandler.this.log.debug("query failed as unsupported, retrying without paging/sorting", (Throwable)ex);
                it = this.queryUnpaged(baseQueryString, resolver);
            }
            long count = 0L;
            while (it.hasNext()) {
                ++count;
                AliasHandler.this.loadAlias(it.next(), map, conflictingAliases, invalidAliases);
            }
            if (it instanceof PagedQueryIterator) {
                PagedQueryIterator pit = (PagedQueryIterator)it;
                if (!pit.getWarning().isEmpty()) {
                    AliasHandler.this.log.warn(pit.getWarning());
                }
                diagnostics.append(pit.getStatistics());
            }
            if (conflictingAliases.size() >= 50) {
                AliasHandler.this.log.warn("There are {} conflicting aliases; excerpt: {}", (Object)conflictingAliases.size(), conflictingAliases);
            } else if (!conflictingAliases.isEmpty()) {
                AliasHandler.this.log.warn("There are {} conflicting aliases: {}", (Object)conflictingAliases.size(), conflictingAliases);
            }
            if (invalidAliases.size() >= 50) {
                AliasHandler.this.log.warn("There are {} invalid aliases; excerpt: {}", (Object)invalidAliases.size(), invalidAliases);
            } else if (!invalidAliases.isEmpty()) {
                AliasHandler.this.log.warn("There are {} invalid aliases: {}", (Object)invalidAliases.size(), invalidAliases);
            }
            AliasHandler.this.aliasResourcesOnStartup.set(count);
            return map;
        }

        @NotNull
        private String generateAliasQuery() {
            Set<String> allowedLocations = AliasHandler.this.factory.getAllowedAliasLocations();
            StringBuilder baseQuery = new StringBuilder("SELECT [sling:alias] FROM [nt:base] WHERE ");
            if (allowedLocations.isEmpty()) {
                baseQuery.append(QueryBuildHelper.excludeSystemPath());
            } else {
                baseQuery.append(allowedLocations.stream().map(location -> "isdescendantnode('" + QueryBuildHelper.escapeString(location) + "')").collect(Collectors.joining(" OR ", "(", ")")));
            }
            baseQuery.append(" AND [sling:alias] IS NOT NULL");
            return baseQuery.toString();
        }

        @NotNull
        private Iterator<Resource> queryUnpaged(@NotNull String query, @NotNull ResourceResolver resolver) {
            AliasHandler.this.log.debug("start alias query: {}", (Object)query);
            StopWatch sw = StopWatch.createStarted();
            Iterator it = resolver.findResources(query, "JCR-SQL2");
            AliasHandler.this.log.debug("end alias query; elapsed {} ({}ms)", (Object)sw.getDuration(), (Object)sw.getDuration().toMillis());
            return it;
        }
    }
}

