/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;

public class H5DataLayoutMessage
extends H5Message {
    private final long address;
    private final long size;

    public H5DataLayoutMessage(H5RootObject rootObject, BitSet flags, ByteBuffer bb) {
        super(rootObject, flags);
        rootObject.setDataLayoutVersion(bb.get());
        rootObject.setDataLayoutClass(bb.get());
        this.address = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfOffsets);
        this.size = Utils.readBytesAsUnsignedLong(bb, rootObject.getSuperblock().sizeOfLengths);
    }

    public H5DataLayoutMessage(H5RootObject rootObject, BitSet flags, long address, long size) {
        super(rootObject, flags);
        this.address = address;
        this.size = size;
    }

    @Override
    public void toBuffer(H5BufferBuilder bb) {
        super.toBuffer(bb, 8);
        bb.writeByte(this.rootObject.getDataLayoutVersion());
        bb.writeByte(this.rootObject.getDataLayoutClass());
        bb.writeLong(this.address);
        bb.writeLong(this.size);
        byte[] reserved = new byte[6];
        bb.writeBytes(reserved);
    }

    public long getAddress() {
        return this.address;
    }

    public long getSize() {
        return this.size;
    }
}

