/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class QuickTypeSelectionDialog
extends PopupDialog {
    private final AnnotationEditor editor;
    private Text filterText;
    private Map<Character, Type> shortcutTypeMap = new HashMap<Character, Type>();
    private Map<Type, Character> typeShortcutMap = new HashMap<Type, Character>();

    QuickTypeSelectionDialog(Shell parent, AnnotationEditor editor) {
        super(parent, 16, true, true, false, true, null, null);
        Character candidateChar;
        String name;
        Type type;
        this.editor = editor;
        String shortcutsString = "qwertzuiopasdfghjklyxcvbnm1234567890";
        HashSet<Character> shortcuts = new HashSet<Character>();
        for (int i = 0; i < shortcutsString.length(); ++i) {
            shortcuts.add(Character.valueOf(shortcutsString.charAt(i)));
        }
        ArrayList types = new ArrayList();
        Collections.addAll(types, this.getTypes());
        Collections.sort(types, new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterator it = types.iterator();
        while (it.hasNext()) {
            type = (Type)it.next();
            name = type.getShortName();
            candidateChar = Character.valueOf(Character.toLowerCase(name.charAt(0)));
            if (!shortcuts.contains(candidateChar)) continue;
            this.putShortcut(candidateChar, type);
            shortcuts.remove(candidateChar);
            it.remove();
        }
        it = types.iterator();
        while (it.hasNext()) {
            type = (Type)it.next();
            name = type.getShortName();
            if (name.length() <= 2 || !shortcuts.contains(candidateChar = Character.valueOf(Character.toLowerCase(name.charAt(1))))) continue;
            this.putShortcut(candidateChar, type);
            shortcuts.remove(candidateChar);
            it.remove();
        }
        it = types.iterator();
        while (it.hasNext() && shortcuts.size() > 0) {
            Character candidateChar2 = (Character)shortcuts.iterator().next();
            this.putShortcut(candidateChar2, (Type)it.next());
            shortcuts.remove(candidateChar2);
            it.remove();
        }
    }

    private void putShortcut(Character shortcut, Type type) {
        this.shortcutTypeMap.put(shortcut, type);
        this.typeShortcutMap.put(type, shortcut);
    }

    private Type[] getTypes() {
        TypeSystem typeSystem = this.editor.getDocument().getCAS().getTypeSystem();
        List types = typeSystem.getProperlySubsumedTypes(typeSystem.getType("uima.tcas.Annotation"));
        types.add(typeSystem.getType("uima.tcas.Annotation"));
        return types.toArray(new Type[types.size()]);
    }

    private void annotateAndClose(Type annotationType) {
        if (annotationType != null) {
            Point textSelection = this.editor.getSelection();
            AnnotationFS annotation = this.editor.getDocument().getCAS().createAnnotation(annotationType, textSelection.x, textSelection.y);
            this.editor.getDocument().addFeatureStructure((FeatureStructure)annotation);
            if (annotation.getType().equals(this.editor.getAnnotationMode())) {
                this.editor.setAnnotationSelection(annotation);
            }
        }
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filterText = new Text(composite, 524288);
        this.filterText.setBackground(parent.getBackground());
        this.filterText.setLayoutData((Object)new GridData(768));
        Label separator = new Label(composite, 259);
        separator.setLayoutData((Object)new GridData(768));
        final TreeViewer typeTree = new TreeViewer(composite, 516);
        typeTree.getControl().setLayoutData((Object)new GridData(1808));
        typeTree.getControl().setFocus();
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    typeTree.getControl().setFocus();
                    Tree tree = (Tree)typeTree.getControl();
                    if (tree.getItemCount() > 0) {
                        tree.setSelection(tree.getItem(0));
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                typeTree.refresh(false);
            }
        });
        typeTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return (Type[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        typeTree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Type type = (Type)element;
                return type.getName().contains(QuickTypeSelectionDialog.this.filterText.getText());
            }
        }});
        typeTree.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Type type = (Type)element;
                Character key = (Character)QuickTypeSelectionDialog.this.typeShortcutMap.get(type);
                if (key != null) {
                    return "[" + key + "] " + type.getShortName();
                }
                return type.getShortName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        typeTree.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                Type type = (Type)QuickTypeSelectionDialog.this.shortcutTypeMap.get(Character.valueOf(Character.toLowerCase(e.character)));
                if (type != null) {
                    QuickTypeSelectionDialog.this.annotateAndClose(type);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        typeTree.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Tree tree = (Tree)typeTree.getControl();
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null) {
                    tree.setSelection(item);
                }
            }
        });
        typeTree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                QuickTypeSelectionDialog.this.annotateAndClose((Type)selection.getFirstElement());
            }
        });
        Collection<Type> shownAnnotationTypes = this.editor.getShownAnnotationTypes();
        Type[] types = shownAnnotationTypes.toArray(new Type[shownAnnotationTypes.size()]);
        typeTree.setInput((Object)types);
        StructuredSelection modeSelection = new StructuredSelection(new Object[]{this.editor.getAnnotationMode()});
        typeTree.setSelection((ISelection)modeSelection, true);
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(250, 300);
    }
}

