/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.AttributeMap;

public class JavaScriptContentHeaderItem
extends JavaScriptHeaderItem {
    private final CharSequence javaScript;

    public JavaScriptContentHeaderItem(CharSequence javaScript, String id) {
        this.javaScript = javaScript;
        this.setId(id);
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute("type", "text/javascript");
        attributes.putAttribute("id", this.getId());
        attributes.putAttribute("nonce", this.getNonce());
        JavaScriptUtils.writeInlineScript(response, this.getJavaScript(), attributes);
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList(this.getJavaScript());
        }
        return Arrays.asList(this.getId(), this.getJavaScript());
    }

    public String toString() {
        return "JavaScriptHeaderItem(" + String.valueOf(this.getJavaScript()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptContentHeaderItem that = (JavaScriptContentHeaderItem)o;
        return Objects.equals(this.javaScript, that.javaScript);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.javaScript != null ? this.javaScript.hashCode() : 0);
        return result;
    }
}

