/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling.model;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class TaskNameComparator
implements Comparator<String>,
Serializable {
    @Override
    public int compare(String taskName1, String taskName2) {
        int depthDiff = TaskNameComparator.getDepth(taskName1) - TaskNameComparator.getDepth(taskName2);
        if (depthDiff != 0) {
            return depthDiff;
        }
        return this.compareSegments(taskName1, taskName2);
    }

    private int compareSegments(String taskName1, String taskName2) {
        int diff;
        int colon1 = taskName1.indexOf(58);
        int colon2 = taskName2.indexOf(58);
        if (colon1 > 0 && colon2 > 0 && (diff = taskName1.substring(0, colon1).compareTo(taskName2.substring(0, colon2))) != 0) {
            return diff;
        }
        return colon1 == -1 ? taskName1.compareTo(taskName2) : this.compareSegments(taskName1.substring(colon1 + 1), taskName2.substring(colon2 + 1));
    }

    static int getDepth(String taskName) {
        return StringUtils.countMatches((CharSequence)taskName, (CharSequence)":");
    }
}

