/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.gradle.api.problems.DocLink;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.DeprecatedUsageProgressDetails;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.problems.ProblemDiagnostics;

public class DefaultDeprecatedUsageProgressDetails
implements DeprecatedUsageProgressDetails,
CustomOperationTraceSerialization {
    @VisibleForTesting
    public final DeprecatedFeatureUsage featureUsage;
    private final ProblemDiagnostics diagnostics;

    public DefaultDeprecatedUsageProgressDetails(DeprecatedFeatureUsage featureUsage, ProblemDiagnostics diagnostics) {
        this.featureUsage = featureUsage;
        this.diagnostics = diagnostics;
    }

    public String getSummary() {
        return this.featureUsage.getSummary();
    }

    public String getRemovalDetails() {
        return this.featureUsage.getRemovalDetails();
    }

    public String getAdvice() {
        return this.featureUsage.getAdvice();
    }

    public String getContextualAdvice() {
        return this.featureUsage.getContextualAdvice();
    }

    public String getDocumentationUrl() {
        DocLink documentationUrl = this.featureUsage.getDocumentationUrl();
        return documentationUrl == null ? null : documentationUrl.getUrl();
    }

    public String getType() {
        return this.featureUsage.getType().name();
    }

    public List<StackTraceElement> getStackTrace() {
        return this.diagnostics.getStack();
    }

    public Object getCustomOperationTraceSerializableModel() {
        LinkedHashMap<String, String> deprecation = new LinkedHashMap<String, String>();
        deprecation.put("summary", this.getSummary());
        deprecation.put("removalDetails", this.getRemovalDetails());
        deprecation.put("advice", this.getAdvice());
        deprecation.put("contextualAdvice", this.getContextualAdvice());
        deprecation.put("documentationUrl", this.getDocumentationUrl());
        deprecation.put("type", this.getType());
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : this.getStackTrace()) {
            sb.append(ste.toString());
            sb.append(SystemProperties.getInstance().getLineSeparator());
        }
        deprecation.put("stackTrace", sb.toString());
        return Collections.singletonMap("deprecation", deprecation);
    }
}

