/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.MoveColumnsRequestPlace;
import com.intellij.database.run.ui.table.AdjustColumnsAfterMoveInData;
import com.intellij.database.run.ui.table.TableResultView;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/ui/table/MoveColumnListener;", "Ljava/awt/event/MouseListener;", "Ljavax/swing/event/TableColumnModelListener;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "tableResultView", "Lcom/intellij/database/run/ui/table/TableResultView;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/run/ui/table/TableResultView;)V", "draggingState", "Lcom/intellij/database/run/ui/table/MoveColumnListener$DraggingState;", "mouseReleased", "", "e", "Ljava/awt/event/MouseEvent;", "columnMoved", "Ljavax/swing/event/TableColumnModelEvent;", "mousePressed", "mouseClicked", "mouseEntered", "mouseExited", "columnAdded", "columnRemoved", "columnMarginChanged", "Ljavax/swing/event/ChangeEvent;", "columnSelectionChanged", "Ljavax/swing/event/ListSelectionEvent;", "DraggingState", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nMoveColumnListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveColumnListener.kt\ncom/intellij/database/run/ui/table/MoveColumnListener\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,111:1\n32#2,2:112\n*S KotlinDebug\n*F\n+ 1 MoveColumnListener.kt\ncom/intellij/database/run/ui/table/MoveColumnListener\n*L\n21#1:112,2\n*E\n"})
public final class MoveColumnListener
implements MouseListener,
TableColumnModelListener {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final TableResultView tableResultView;
    @NotNull
    private DraggingState draggingState;

    public MoveColumnListener(@NotNull DataGrid grid, @NotNull TableResultView tableResultView) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)tableResultView, (String)"tableResultView");
        this.grid = grid;
        this.tableResultView = tableResultView;
        this.draggingState = DraggingState.NONE;
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.draggingState == DraggingState.MOVED) {
            GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
            List order = new ArrayList();
            Iterator<TableColumn> iterator = this.tableResultView.getColumnModel().getColumns().asIterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"asIterator(...)");
            Iterator<TableColumn> $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator<TableColumn> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                TableColumn element$iv;
                TableColumn it = element$iv = iterator2.next();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                order.add(it);
            }
            int from = -1;
            int to = -1;
            int n = order.size() - 1;
            for (int i = 0; i < n; ++i) {
                int next;
                int cur = ((TableColumn)order.get(i)).getModelIndex();
                if (cur <= (next = ((TableColumn)order.get(i + 1)).getModelIndex())) continue;
                if (from != -1) {
                    return;
                }
                if (i + 2 < order.size() && cur > ((TableColumn)order.get(i + 2)).getModelIndex()) {
                    from = cur;
                    to = next;
                    continue;
                }
                from = next;
                to = cur;
            }
            if (from == -1) {
                return;
            }
            GridMutator.ColumnsMutator<GridRow, GridColumn> columnsMutator = mutator = GridUtil.getColumnsMutator(this.grid);
            if (columnsMutator != null) {
                columnsMutator.moveColumn(new GridRequestSource((GridRequestSource.RequestPlace)new MoveColumnsRequestPlace((CoreGrid)this.grid, () -> MoveColumnListener.mouseReleased$lambda$1(this), (Function0)new AdjustColumnsAfterMoveInData(this.grid, this.tableResultView, from, to))), ModelIndex.forColumn((CoreGrid)this.grid, (int)from), ModelIndex.forColumn((CoreGrid)this.grid, (int)to));
            }
        }
        this.draggingState = DraggingState.NONE;
    }

    @Override
    public void columnMoved(@NotNull TableColumnModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.draggingState == DraggingState.GRABBED && e.getFromIndex() != e.getToIndex()) {
            this.draggingState = DraggingState.MOVED;
        }
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.draggingState = DraggingState.GRABBED;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void columnAdded(@NotNull TableColumnModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void columnRemoved(@NotNull TableColumnModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void columnMarginChanged(@NotNull ChangeEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void columnSelectionChanged(@NotNull ListSelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private static final AutoCloseable mouseReleased$lambda$1(MoveColumnListener this$0) {
        return new AutoCloseable(this$0){
            final /* synthetic */ MoveColumnListener this$0;
            {
                this.this$0 = $receiver;
                MoveColumnListener.access$getTableResultView$p($receiver).setEditingBlocked(true);
                MoveColumnListener.access$getGrid$p($receiver).getPanel().getComponent().setLoadingText(DataGridBundle.message((String)"DataView.updatingFile", (Object[])new Object[0]));
                MoveColumnListener.access$getGrid$p($receiver).getPanel().getComponent().startLoading();
            }

            public void close() {
                MoveColumnListener.access$getGrid$p(this.this$0).getPanel().getComponent().stopLoading();
                MoveColumnListener.access$getTableResultView$p(this.this$0).setEditingBlocked(false);
            }
        };
    }

    public static final /* synthetic */ TableResultView access$getTableResultView$p(MoveColumnListener $this) {
        return $this.tableResultView;
    }

    public static final /* synthetic */ DataGrid access$getGrid$p(MoveColumnListener $this) {
        return $this.grid;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/run/ui/table/MoveColumnListener$DraggingState;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "GRABBED", "MOVED", "intellij.grid.impl"})
    public static final class DraggingState
    extends Enum<DraggingState> {
        public static final /* enum */ DraggingState NONE = new DraggingState();
        public static final /* enum */ DraggingState GRABBED = new DraggingState();
        public static final /* enum */ DraggingState MOVED = new DraggingState();
        private static final /* synthetic */ DraggingState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DraggingState[] values() {
            return (DraggingState[])$VALUES.clone();
        }

        public static DraggingState valueOf(String value) {
            return Enum.valueOf(DraggingState.class, value);
        }

        @NotNull
        public static EnumEntries<DraggingState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = draggingStateArray = new DraggingState[]{DraggingState.NONE, DraggingState.GRABBED, DraggingState.MOVED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

