/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrPatternVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre50;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "getHolder", "()Lcom/intellij/lang/annotation/AnnotationHolder;", "visitPatternVariable", "", "variable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrPatternVariable;", "visitBinaryExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "visitNewExpression", "newExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrNewExpression;", "visitForInClause", "forInClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrForInClause;", "error", "element", "Lcom/intellij/psi/PsiElement;", "feature", "Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre50$Groovy5Features;", "Groovy5Features", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotatorPre50.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotatorPre50.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre50\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1761#2,3:60\n*S KotlinDebug\n*F\n+ 1 GroovyAnnotatorPre50.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre50\n*L\n33#1:60,3\n*E\n"})
public final class GroovyAnnotatorPre50
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotatorPre50(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @NotNull
    public final AnnotationHolder getHolder() {
        return this.holder;
    }

    @Override
    public void visitPatternVariable(@NotNull GrPatternVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.error(variable, Groovy5Features.PATTERN_MATCHING);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)expression.getOperator(), (Object)GroovyTokenTypes.mIMPL)) {
            PsiElement psiElement = expression.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
            this.error(psiElement, Groovy5Features.LOGICAL_IMPLICATION);
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)newExpression, (String)"newExpression");
            GrArrayDeclaration arrayDeclaration = newExpression.getArrayDeclaration();
            GrArrayInitializer arrayInitializer = newExpression.getArrayInitializer();
            if (arrayDeclaration == null || arrayInitializer == null) {
                return;
            }
            List<GrExpression> list = arrayInitializer.getExpressions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressions(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GrExpression it = (GrExpression)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof GrArrayInitializer)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.error(newExpression, Groovy5Features.MULTI_DIMENSIONAL_ARRAY_INITIALIZER);
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        Intrinsics.checkNotNullParameter((Object)forInClause, (String)"forInClause");
        GrVariable grVariable = forInClause.getIndexVariable();
        if (grVariable == null) {
            return;
        }
        GrVariable indexVariable = grVariable;
        this.error(indexVariable, Groovy5Features.INDEX_VARIABLE_IN_FOREACH_LOOP);
    }

    private final void error(PsiElement element, Groovy5Features feature) {
        String string = GroovyBundle.message(feature.getMessageKey(), new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        Object[] objectArray = new Object[]{message};
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.available.with.groovy.5.or.later", objectArray)).range(element).create();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B \b\u0002\u0012\u0015\u0010\u0002\u001a\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\u0002\u001a\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre50$Groovy5Features;", "", "messageKey", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.GroovyBundle", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessageKey", "()Ljava/lang/String;", "INDEX_VARIABLE_IN_FOREACH_LOOP", "PATTERN_MATCHING", "LOGICAL_IMPLICATION", "MULTI_DIMENSIONAL_ARRAY_INITIALIZER", "intellij.groovy.psi"})
    private static final class Groovy5Features
    extends Enum<Groovy5Features> {
        @NotNull
        private final String messageKey;
        public static final /* enum */ Groovy5Features INDEX_VARIABLE_IN_FOREACH_LOOP = new Groovy5Features("index.variable.in.foreach.loop");
        public static final /* enum */ Groovy5Features PATTERN_MATCHING = new Groovy5Features("instanceof.pattern.variable.feature");
        public static final /* enum */ Groovy5Features LOGICAL_IMPLICATION = new Groovy5Features("logical.implication.feature");
        public static final /* enum */ Groovy5Features MULTI_DIMENSIONAL_ARRAY_INITIALIZER = new Groovy5Features("multi.dimensional.array.initializer.feature");
        private static final /* synthetic */ Groovy5Features[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Groovy5Features(String messageKey) {
            this.messageKey = messageKey;
        }

        @NotNull
        public final String getMessageKey() {
            return this.messageKey;
        }

        public static Groovy5Features[] values() {
            return (Groovy5Features[])$VALUES.clone();
        }

        public static Groovy5Features valueOf(String value) {
            return Enum.valueOf(Groovy5Features.class, value);
        }

        @NotNull
        public static EnumEntries<Groovy5Features> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = groovy5FeaturesArray = new Groovy5Features[]{Groovy5Features.INDEX_VARIABLE_IN_FOREACH_LOOP, Groovy5Features.PATTERN_MATCHING, Groovy5Features.LOGICAL_IMPLICATION, Groovy5Features.MULTI_DIMENSIONAL_ARRAY_INITIALIZER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

