/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MaxLocalsCalculator
extends MethodVisitor {
    private int maxLocals;

    public MaxLocalsCalculator(int api, int access, String descriptor, MethodVisitor mv2) {
        super(api, mv2);
        this.maxLocals = InlineCodegenUtilsKt.argumentsSize(descriptor, (access & 8) != 0);
    }

    public void visitVarInsn(int opcode, int var) {
        int n = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1;
        this.updateMaxLocals(n);
        super.visitVarInsn(opcode, var);
    }

    public void visitIincInsn(int var, int increment) {
        this.updateMaxLocals(var + 1);
        super.visitIincInsn(var, increment);
    }

    public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index) {
        char c;
        if (name == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(0);
        }
        if (desc == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(1);
        }
        if (start == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(2);
        }
        if (end == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(3);
        }
        int n = index + ((c = desc.charAt(0)) == 'J' || c == 'D' ? 2 : 1);
        this.updateMaxLocals(n);
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, this.maxLocals);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    private void updateMaxLocals(int nextFreeSlotNumber) {
        if (nextFreeSlotNumber > this.maxLocals) {
            this.maxLocals = nextFreeSlotNumber;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "desc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "end";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator";
        objectArray[2] = "visitLocalVariable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

