/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.bugzilla.BugzillaRepository;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class BugzillaRepositoryEditor
extends BaseRepositoryEditor<BugzillaRepository> {
    private static final Logger LOG = Logger.getInstance(BugzillaRepository.class);
    private JBLabel myProductLabel;
    private TextFieldWithAutoCompletion<String> myProductInput;
    private JBLabel myComponentLabel;
    private TextFieldWithAutoCompletion<String> myComponentInput;

    public BugzillaRepositoryEditor(Project project, BugzillaRepository repository, Consumer<? super BugzillaRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myUseHttpAuthenticationCheckBox.setVisible(false);
        this.installListener((EditorTextField)this.myProductInput);
        this.installListener((EditorTextField)this.myComponentInput);
        this.myTestButton.setEnabled(((BugzillaRepository)this.myRepository).isConfigured());
        if (((BugzillaRepository)this.myRepository).isConfigured()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.installProductAndComponentCompletion());
        }
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            this.installProductAndComponentCompletion();
        }
    }

    public void apply() {
        super.apply();
        ((BugzillaRepository)this.myRepository).setProductName(this.myProductInput.getText());
        ((BugzillaRepository)this.myRepository).setComponentName(this.myComponentInput.getText());
        this.myTestButton.setEnabled(((BugzillaRepository)this.myRepository).isConfigured());
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProductLabel = new JBLabel(TaskBundle.message((String)"bugzilla.label.product", (Object[])new Object[0]), 4);
        this.myProductInput = TextFieldWithAutoCompletion.create((Project)this.myProject, Collections.emptyList(), (boolean)true, (String)((BugzillaRepository)this.myRepository).getProductName());
        this.myComponentLabel = new JBLabel(TaskBundle.message((String)"bugzilla.label.component", (Object[])new Object[0]), 4);
        this.myComponentInput = TextFieldWithAutoCompletion.create((Project)this.myProject, Collections.emptyList(), (boolean)false, (String)((BugzillaRepository)this.myRepository).getComponentName());
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProductLabel, this.myProductInput).addLabeledComponent((JComponent)this.myComponentLabel, this.myComponentInput).getPanel();
    }

    private void installProductAndComponentCompletion() {
        try {
            Pair<List<String>, List<String>> pair = ((BugzillaRepository)this.myRepository).fetchProductAndComponentNames();
            this.myProductInput.setVariants((Collection)pair.getFirst());
            this.myComponentInput.setVariants((Collection)pair.getSecond());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProductLabel.setAnchor(anchor);
        this.myComponentLabel.setAnchor(anchor);
    }
}

