/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.HashMap;

public class Levenshtein {
    public static int distance(CharSequence lhs, CharSequence rhs) {
        return Levenshtein.distance(lhs, rhs, 1, 1, 1, 1);
    }

    public static int distance(CharSequence source, CharSequence target, int deleteCost, int insertCost, int replaceCost, int swapCost) {
        int matchDistance;
        int insertDistance;
        int deleteDistance;
        int i2;
        if (2 * swapCost < insertCost + deleteCost) {
            throw new IllegalArgumentException("Unsupported cost assignment");
        }
        if (source.length() == 0) {
            return target.length() * insertCost;
        }
        if (target.length() == 0) {
            return source.length() * deleteCost;
        }
        int[][] table = new int[source.length()][target.length()];
        HashMap<Character, Integer> sourceIndexByCharacter = new HashMap<Character, Integer>();
        if (source.charAt(0) != target.charAt(0)) {
            table[0][0] = Math.min(replaceCost, deleteCost + insertCost);
        }
        sourceIndexByCharacter.put(Character.valueOf(source.charAt(0)), 0);
        for (i2 = 1; i2 < source.length(); ++i2) {
            deleteDistance = table[i2 - 1][0] + deleteCost;
            insertDistance = (i2 + 1) * deleteCost + insertCost;
            matchDistance = i2 * deleteCost + (source.charAt(i2) == target.charAt(0) ? 0 : replaceCost);
            table[i2][0] = Math.min(Math.min(deleteDistance, insertDistance), matchDistance);
        }
        for (int j2 = 1; j2 < target.length(); ++j2) {
            deleteDistance = (j2 + 1) * insertCost + deleteCost;
            insertDistance = table[0][j2 - 1] + insertCost;
            matchDistance = j2 * insertCost + (source.charAt(0) == target.charAt(j2) ? 0 : replaceCost);
            table[0][j2] = Math.min(Math.min(deleteDistance, insertDistance), matchDistance);
        }
        for (i2 = 1; i2 < source.length(); ++i2) {
            int maxSourceLetterMatchIndex = source.charAt(i2) == target.charAt(0) ? 0 : -1;
            for (int j3 = 1; j3 < target.length(); ++j3) {
                int swapDistance;
                Integer candidateSwapIndex = (Integer)sourceIndexByCharacter.get(Character.valueOf(target.charAt(j3)));
                int jSwap = maxSourceLetterMatchIndex;
                int deleteDistance2 = table[i2 - 1][j3] + deleteCost;
                int insertDistance2 = table[i2][j3 - 1] + insertCost;
                int matchDistance2 = table[i2 - 1][j3 - 1];
                if (source.charAt(i2) != target.charAt(j3)) {
                    matchDistance2 += replaceCost;
                } else {
                    maxSourceLetterMatchIndex = j3;
                }
                if (candidateSwapIndex != null && jSwap != -1) {
                    int iSwap = candidateSwapIndex;
                    int preSwapCost = iSwap == 0 && jSwap == 0 ? 0 : table[Math.max(0, iSwap - 1)][Math.max(0, jSwap - 1)];
                    swapDistance = preSwapCost + (i2 - iSwap - 1) * deleteCost + (j3 - jSwap - 1) * insertCost + swapCost;
                } else {
                    swapDistance = Integer.MAX_VALUE;
                }
                table[i2][j3] = Math.min(Math.min(Math.min(deleteDistance2, insertDistance2), matchDistance2), swapDistance);
            }
            sourceIndexByCharacter.put(Character.valueOf(source.charAt(i2)), i2);
        }
        return table[source.length() - 1][target.length() - 1];
    }
}

