/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.GradleDependencyResolver;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.CopySpecWalker;
import org.jetbrains.plugins.gradle.tooling.builder.EarModelBuilderImplKt;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarConfigurationImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarResourceImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002JB\u0010\u001c\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00180\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/EarModelBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "collectAppDirName", "task", "Lorg/gradle/plugins/ear/Ear;", "collectEarResources", "", "Lorg/jetbrains/plugins/gradle/model/ear/EarConfiguration$EarResource;", "buildDirPath", "earConfigurations", "Lorg/gradle/api/artifacts/Configuration;", "addEarResource", "", "earDirectory", "relativePath", "file", "Ljava/io/File;", "collectDeploymentDescriptor", "collectManifestContent", "intellij.gradle.toolingExtension.impl"})
@SourceDebugExtension(value={"SMAP\nEarModelBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarModelBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/EarModelBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1761#2,3:161\n*S KotlinDebug\n*F\n+ 1 EarModelBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/EarModelBuilderImpl\n*L\n139#1:161,3\n*E\n"})
public final class EarModelBuilderImpl
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)EarModelBuilderImplKt.access$getEAR_MODEL_NAME$p(), (Object)modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ((EarPlugin)project.getPlugins().findPlugin(EarPlugin.class) == null) {
            return null;
        }
        ArrayList<EarModelImpl> earModels = new ArrayList<EarModelImpl>();
        Configuration deployConfiguration = (Configuration)project.getConfigurations().findByName("deploy");
        Configuration earlibConfiguration = (Configuration)project.getConfigurations().findByName("earlib");
        Object[] objectArray = new Configuration[]{deployConfiguration, earlibConfiguration};
        List earConfigurations = CollectionsKt.listOfNotNull((Object[])objectArray);
        GradleDependencyResolver dependencyResolver = new GradleDependencyResolver(context, project, GradleDependencyDownloadPolicy.NONE);
        Collection<ExternalDependency> collection = dependencyResolver.resolveDependencies(deployConfiguration);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveDependencies(...)");
        Collection<ExternalDependency> deployDependencies = collection;
        Collection<ExternalDependency> collection2 = dependencyResolver.resolveDependencies(earlibConfiguration);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"resolveDependencies(...)");
        Collection<ExternalDependency> earlibDependencies = collection2;
        String buildDirPath = GradleProjectUtil.getBuildDirectory(project).getAbsolutePath();
        for (Ear task : project.getTasks().withType(Ear.class)) {
            File archiveFile;
            String archiveName;
            Intrinsics.checkNotNullExpressionValue((Object)GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)task), (String)"getTaskArchiveFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)GradleTaskUtil.getTaskArchiveFileName((AbstractArchiveTask)task), (String)"getTaskArchiveFileName(...)");
            Intrinsics.checkNotNull((Object)task);
            String appDirName = this.collectAppDirName(project, task);
            String libDirName = task.getLibDirName();
            Intrinsics.checkNotNull((Object)buildDirPath);
            List<EarConfiguration.EarResource> earResources = this.collectEarResources(context, project, task, buildDirPath, earConfigurations);
            String deploymentDescriptor = this.collectDeploymentDescriptor(task);
            String manifestContent = this.collectManifestContent(task);
            EarModelImpl earModel = new EarModelImpl(archiveName, appDirName, libDirName);
            earModel.setResources(earResources);
            earModel.setDeploymentDescriptor(deploymentDescriptor);
            earModel.setArchivePath(archiveFile);
            earModel.setManifestContent(manifestContent);
            earModels.add(earModel);
        }
        return new EarConfigurationImpl((List<? extends EarConfiguration.EarModel>)earModels, deployDependencies, earlibDependencies);
    }

    private final void reportErrorMessage(ModelBuilderContext context, Project project, Exception exception) {
        String string = EarModelBuilderImplKt.access$getEAR_MODEL_NAME$p();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getEAR_MODEL_NAME$p(...)");
        this.reportErrorMessage(string, project, context, exception);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.earConfigurationModel.group").withKind(Message.Kind.WARNING).withTitle("JEE project import failure").withText("Ear Facets/Artifacts may not be configured properly").withException(exception).reportMessage(project);
    }

    private final String collectAppDirName(Project project, Ear task) {
        if (EarModelBuilderImplKt.access$is82OrBetter$p()) {
            Object object = task.getAppDirectory().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            File appDir = (File)object;
            String string = appDir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }
        Object object = project.findProperty("appDirName");
        if (object == null || (object = object.toString()) == null) {
            object = "src/main/application";
        }
        return object;
    }

    private final List<EarConfiguration.EarResource> collectEarResources(ModelBuilderContext context, Project project, Ear task, String buildDirPath, List<? extends Configuration> earConfigurations) {
        try {
            ArrayList<EarConfiguration.EarResource> earResources = new ArrayList<EarConfiguration.EarResource>();
            CopySpecWalker.walk((CopySpec)task.getRootSpec(), new CopySpecWalker.Visitor(task, this, earResources, buildDirPath, earConfigurations){
                final /* synthetic */ Ear $task;
                final /* synthetic */ EarModelBuilderImpl this$0;
                final /* synthetic */ ArrayList<EarConfiguration.EarResource> $earResources;
                final /* synthetic */ String $buildDirPath;
                final /* synthetic */ List<Configuration> $earConfigurations;
                {
                    this.$task = $task;
                    this.this$0 = $receiver;
                    this.$earResources = $earResources;
                    this.$buildDirPath = $buildDirPath;
                    this.$earConfigurations = $earConfigurations;
                }

                public void visitSourcePath(String relativePath, String path) {
                    File file;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    File it = file = new File(path);
                    boolean bl = false;
                    File file2 = it.isAbsolute() ? file : null;
                    if (file2 == null) {
                        file2 = new File(this.$task.getProject().getProjectDir(), path);
                    }
                    File file3 = file2;
                    EarModelBuilderImpl.access$addEarResource(this.this$0, this.$earResources, relativePath, "", file3, this.$buildDirPath, this.$earConfigurations);
                }

                public void visitDir(String relativePath, FileVisitDetails dirDetails) {
                    Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
                    List list = this.$earResources;
                    String string = dirDetails.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    File file = dirDetails.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    EarModelBuilderImpl.access$addEarResource(this.this$0, list, relativePath, string, file, this.$buildDirPath, this.$earConfigurations);
                }

                public void visitFile(String relativePath, FileVisitDetails fileDetails) {
                    Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
                    List list = this.$earResources;
                    String string = fileDetails.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    File file = fileDetails.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    EarModelBuilderImpl.access$addEarResource(this.this$0, list, relativePath, string, file, this.$buildDirPath, this.$earConfigurations);
                }
            });
            return earResources;
        }
        catch (Exception e) {
            this.reportErrorMessage(context, project, e);
            return CollectionsKt.emptyList();
        }
    }

    private final void addEarResource(List<EarConfiguration.EarResource> $this$addEarResource, String earDirectory, String relativePath, File file, String buildDirPath, List<? extends Configuration> earConfigurations) {
        boolean bl;
        block6: {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.startsWith$default((String)string, (String)buildDirPath, (boolean)false, (int)2, null)) {
                return;
            }
            Iterable $this$any$iv = earConfigurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Configuration it = (Configuration)element$iv;
                    boolean bl2 = false;
                    if (!it.getFiles().contains(file)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        String string = earDirectory;
        if (string == null) {
            string = "";
        }
        $this$addEarResource.add(new EarResourceImpl(string, relativePath, file));
    }

    private final String collectDeploymentDescriptor(Ear task) {
        DeploymentDescriptor deploymentDescriptor = task.getDeploymentDescriptor();
        if (deploymentDescriptor == null) {
            return null;
        }
        DeploymentDescriptor deploymentDescriptor2 = deploymentDescriptor;
        StringWriter writer = new StringWriter();
        deploymentDescriptor2.writeTo((Writer)writer);
        return writer.toString();
    }

    private final String collectManifestContent(Ear task) {
        Manifest manifest = task.getManifest();
        if (!(manifest instanceof ManifestInternal)) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((ManifestInternal)manifest).writeTo((OutputStream)outputStream);
        String contentCharset = ((ManifestInternal)manifest).getContentCharset();
        return outputStream.toString(contentCharset);
    }

    public static final /* synthetic */ void access$addEarResource(EarModelBuilderImpl $this, List $receiver, String earDirectory, String relativePath, File file, String buildDirPath, List earConfigurations) {
        $this.addEarResource($receiver, earDirectory, relativePath, file, buildDirPath, earConfigurations);
    }
}

